/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eluder.coveralls.maven.plugin.CoverageParser;
import org.eluder.coveralls.maven.plugin.Environment;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.CoverallsResponse;
import org.eluder.coveralls.maven.plugin.domain.Git;
import org.eluder.coveralls.maven.plugin.domain.GitRepository;
import org.eluder.coveralls.maven.plugin.domain.Job;
import org.eluder.coveralls.maven.plugin.httpclient.CoverallsClient;
import org.eluder.coveralls.maven.plugin.json.JsonWriter;
import org.eluder.coveralls.maven.plugin.logging.CoverageTracingLogger;
import org.eluder.coveralls.maven.plugin.logging.DryRunLogger;
import org.eluder.coveralls.maven.plugin.logging.JobLogger;
import org.eluder.coveralls.maven.plugin.logging.Logger;
import org.eluder.coveralls.maven.plugin.service.Bamboo;
import org.eluder.coveralls.maven.plugin.service.Circle;
import org.eluder.coveralls.maven.plugin.service.General;
import org.eluder.coveralls.maven.plugin.service.Jenkins;
import org.eluder.coveralls.maven.plugin.service.ServiceSetup;
import org.eluder.coveralls.maven.plugin.service.Shippable;
import org.eluder.coveralls.maven.plugin.service.Travis;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;
import org.eluder.coveralls.maven.plugin.source.UniqueSourceCallback;
import org.eluder.coveralls.maven.plugin.util.CoverageParsersFactory;
import org.eluder.coveralls.maven.plugin.util.SourceLoaderFactory;

@Mojo(name="report", threadSafe=false, aggregator=true)
public class CoverallsReportMojo
extends AbstractMojo {
    @Parameter(property="jacocoReports")
    protected List<File> jacocoReports;
    @Parameter(property="coberturaReports")
    protected List<File> coberturaReports;
    @Parameter(property="sagaReports")
    protected List<File> sagaReports;
    @Parameter(property="relativeReportDirs")
    protected List<String> relativeReportDirs;
    @Parameter(property="coverallsFile", defaultValue="${project.build.directory}/coveralls.json")
    protected File coverallsFile;
    @Parameter(property="coverallsUrl", defaultValue="https://coveralls.io/api/v1/jobs")
    protected String coverallsUrl;
    @Parameter(property="sourceDirectories")
    protected List<File> sourceDirectories;
    @Parameter(property="sourceEncoding", defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="serviceName")
    protected String serviceName;
    @Parameter(property="serviceJobId")
    protected String serviceJobId;
    @Parameter(property="serviceBuildNumber")
    protected String serviceBuildNumber;
    @Parameter(property="serviceBuildUrl")
    protected String serviceBuildUrl;
    @Parameter(property="serviceEnvironment")
    protected Properties serviceEnvironment;
    @Parameter(property="repoToken")
    protected String repoToken;
    @Parameter(property="branch")
    protected String branch;
    @Parameter(property="pullRequest")
    protected String pullRequest;
    @Parameter(property="timestamp", defaultValue="${timestamp}")
    protected Date timestamp;
    @Parameter(property="dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="scanForSources", defaultValue="false")
    protected boolean scanForSources;
    @Parameter(property="coveralls.basedir", defaultValue="${project.basedir}")
    protected File basedir;
    @Parameter(property="coveralls.skip", defaultValue="false")
    protected boolean skip;
    @Component
    protected MavenProject project;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip property set, skipping plugin execution");
            return;
        }
        try {
            this.createEnvironment().setup();
            Job job = this.createJob();
            job.validate().throwOrInform(this.getLog());
            SourceLoader sourceLoader = this.createSourceLoader(job);
            List<CoverageParser> parsers = this.createCoverageParsers(sourceLoader);
            JsonWriter writer = this.createJsonWriter(job);
            CoverallsClient client = this.createCoverallsClient();
            ArrayList<Logger> reporters = new ArrayList<Logger>();
            reporters.add(new JobLogger(job));
            SourceCallback sourceCallback = this.createSourceCallbackChain(writer, reporters);
            reporters.add(new DryRunLogger(job.isDryRun(), writer.getCoverallsFile()));
            this.report(reporters, Logger.Position.BEFORE);
            this.writeCoveralls(writer, sourceLoader, sourceCallback, parsers);
            this.report(reporters, Logger.Position.AFTER);
            if (!job.isDryRun()) {
                this.submitData(client, writer.getCoverallsFile());
            }
        }
        catch (ProcessingException ex) {
            throw new MojoFailureException("Processing of input or output data failed", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new MojoFailureException("I/O operation failed", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Build error", ex);
        }
    }

    protected List<CoverageParser> createCoverageParsers(SourceLoader sourceLoader) throws IOException {
        return new CoverageParsersFactory(this.project, sourceLoader).withJaCoCoReports(this.jacocoReports).withCoberturaReports(this.coberturaReports).withSagaReports(this.sagaReports).withRelativeReportDirs(this.relativeReportDirs).createParsers();
    }

    protected SourceLoader createSourceLoader(Job job) {
        return new SourceLoaderFactory(job.getGit().getBaseDir(), this.project, this.sourceEncoding).withSourceDirectories(this.sourceDirectories).withScanForSources(this.scanForSources).createSourceLoader();
    }

    protected Environment createEnvironment() {
        return new Environment(this, this.getServices());
    }

    protected List<ServiceSetup> getServices() {
        Map<String, String> env = System.getenv();
        ArrayList<ServiceSetup> services = new ArrayList<ServiceSetup>();
        services.add(new Shippable(env));
        services.add(new Travis(env));
        services.add(new Circle(env));
        services.add(new Jenkins(env));
        services.add(new Bamboo(env));
        services.add(new General(env));
        return services;
    }

    protected Job createJob() throws IOException {
        Git git = new GitRepository(this.basedir).load();
        return new Job().withRepoToken(this.repoToken).withServiceName(this.serviceName).withServiceJobId(this.serviceJobId).withServiceBuildNumber(this.serviceBuildNumber).withServiceBuildUrl(this.serviceBuildUrl).withServiceEnvironment(this.serviceEnvironment).withTimestamp(this.timestamp).withDryRun(this.dryRun).withBranch(this.branch).withPullRequest(this.pullRequest).withGit(git);
    }

    protected JsonWriter createJsonWriter(Job job) throws IOException {
        return new JsonWriter(job, this.coverallsFile);
    }

    protected CoverallsClient createCoverallsClient() {
        return new CoverallsClient(this.coverallsUrl);
    }

    protected SourceCallback createSourceCallbackChain(JsonWriter writer, List<Logger> reporters) {
        SourceCallback chain = writer;
        if (this.getLog().isInfoEnabled()) {
            CoverageTracingLogger coverageTracingReporter = new CoverageTracingLogger(chain);
            chain = coverageTracingReporter;
            reporters.add(coverageTracingReporter);
        }
        chain = new UniqueSourceCallback(chain);
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCoveralls(JsonWriter writer, SourceLoader sourceLoader, SourceCallback sourceCallback, List<CoverageParser> parsers) throws ProcessingException, IOException {
        try {
            this.getLog().info((CharSequence)("Writing Coveralls data to " + writer.getCoverallsFile().getAbsolutePath() + "..."));
            long now = System.currentTimeMillis();
            writer.writeStart();
            for (CoverageParser parser : parsers) {
                this.getLog().info((CharSequence)("Processing coverage report from " + parser.getCoverageFile().getAbsolutePath()));
                parser.parse(sourceCallback);
            }
            writer.writeEnd();
            long duration = System.currentTimeMillis() - now;
            this.getLog().info((CharSequence)("Successfully wrote Coveralls data in " + duration + "ms"));
        }
        finally {
            writer.close();
        }
    }

    private void submitData(CoverallsClient client, File coverallsFile) throws ProcessingException, IOException {
        this.getLog().info((CharSequence)"Submitting Coveralls data to API");
        long now = System.currentTimeMillis();
        try {
            CoverallsResponse response = client.submit(coverallsFile);
            long duration = System.currentTimeMillis() - now;
            this.getLog().info((CharSequence)("Successfully submitted Coveralls data in " + duration + "ms for " + response.getMessage()));
            this.getLog().info((CharSequence)response.getUrl());
            this.getLog().info((CharSequence)"*** It might take hours for Coveralls to update the actual coverage numbers for a job");
            this.getLog().info((CharSequence)"    If you see question marks in the report, please be patient");
        }
        catch (ProcessingException ex) {
            long duration = System.currentTimeMillis() - now;
            this.getLog().error((CharSequence)("Submission failed in " + duration + "ms while processing data"));
            throw ex;
        }
        catch (IOException ex) {
            long duration = System.currentTimeMillis() - now;
            this.getLog().error((CharSequence)("Submission failed in " + duration + "ms while handling I/O operations"));
            throw ex;
        }
    }

    private void report(List<Logger> reporters, Logger.Position position) {
        for (Logger reporter : reporters) {
            if (!position.equals((Object)reporter.getPosition())) continue;
            reporter.log(this.getLog());
        }
    }
}

