/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.ComponentInfo;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;

public class BackingStoreHelper {
    private BackingStoreHelper() {
    }

    public static ObjectProvider getOwnerObjectProviderForBackingStore(ObjectProvider op) {
        ObjectProvider ownerOP = op;
        while (ownerOP.isEmbedded()) {
            ObjectProvider[] ownerOPs = op.getExecutionContext().getOwnersForEmbeddedObjectProvider(ownerOP);
            if (ownerOPs != null && ownerOPs.length == 1) {
                ownerOP = ownerOPs[0];
                continue;
            }
            if (ownerOPs == null || ownerOPs.length == 0) {
                return null;
            }
            ownerOP = ownerOPs[0];
        }
        return ownerOP;
    }

    public static int populateOwnerInStatement(ObjectProvider op, ExecutionContext ec, PreparedStatement ps, int jdbcPosition, BaseContainerStore bcs) {
        boolean embedded = false;
        ObjectProvider ownerOP = BackingStoreHelper.getOwnerObjectProviderForBackingStore(op);
        if (ownerOP != op) {
            embedded = true;
        }
        if (!bcs.getStoreManager().insertValuesOnInsert(bcs.getOwnerMapping().getColumnMapping(0))) {
            return jdbcPosition;
        }
        if (bcs.getOwnerMemberMetaData() != null && !embedded) {
            bcs.getOwnerMapping().setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, bcs.getOwnerMapping()), ownerOP.getObject(), ownerOP, bcs.getOwnerMemberMetaData().getAbsoluteFieldNumber());
        } else {
            bcs.getOwnerMapping().setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, bcs.getOwnerMapping()), ownerOP.getObject());
        }
        return jdbcPosition + bcs.getOwnerMapping().getNumberOfColumnMappings();
    }

    public static int populateRelationDiscriminatorInStatement(ExecutionContext ec, PreparedStatement ps, int jdbcPosition, ElementContainerStore ecs) {
        ecs.getRelationDiscriminatorMapping().setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, ecs.getRelationDiscriminatorMapping()), ecs.getRelationDiscriminatorValue());
        return jdbcPosition + ecs.getRelationDiscriminatorMapping().getNumberOfColumnMappings();
    }

    public static int populateOrderInStatement(ExecutionContext ec, PreparedStatement ps, int idx, int jdbcPosition, JavaTypeMapping orderMapping) {
        orderMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, orderMapping), idx);
        return jdbcPosition + orderMapping.getNumberOfColumnMappings();
    }

    public static int populateElementInStatement(ExecutionContext ec, PreparedStatement ps, Object element, int jdbcPosition, JavaTypeMapping elementMapping) {
        if (!elementMapping.getStoreManager().insertValuesOnInsert(elementMapping.getColumnMapping(0))) {
            return jdbcPosition;
        }
        elementMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, elementMapping), element);
        return jdbcPosition + elementMapping.getNumberOfColumnMappings();
    }

    public static int populateElementForWhereClauseInStatement(ExecutionContext ec, PreparedStatement ps, Object element, int jdbcPosition, JavaTypeMapping elementMapping) {
        if (elementMapping.getStoreManager().insertValuesOnInsert(elementMapping.getColumnMapping(0))) {
            if (elementMapping instanceof ReferenceMapping && elementMapping.getNumberOfColumnMappings() > 1) {
                ReferenceMapping elemRefMapping = (ReferenceMapping)elementMapping;
                JavaTypeMapping[] elemFkMappings = elemRefMapping.getJavaTypeMapping();
                int[] positions = null;
                for (int i = 0; i < elemFkMappings.length; ++i) {
                    if (!elemFkMappings[i].getType().equals(element.getClass().getName())) continue;
                    positions = new int[elemFkMappings[i].getNumberOfColumnMappings()];
                    for (int j = 0; j < positions.length; ++j) {
                        positions[j] = jdbcPosition++;
                    }
                }
                if (positions != null) {
                    elementMapping.setObject(ec, ps, positions, element);
                    jdbcPosition += positions.length;
                }
            } else {
                elementMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, elementMapping), element);
                jdbcPosition += elementMapping.getNumberOfColumnMappings();
            }
        }
        return jdbcPosition;
    }

    public static int populateKeyInStatement(ExecutionContext ec, PreparedStatement ps, Object key, int jdbcPosition, JavaTypeMapping keyMapping) {
        if (!keyMapping.getColumnMapping(0).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        keyMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, keyMapping), key);
        return jdbcPosition + keyMapping.getNumberOfColumnMappings();
    }

    public static int populateValueInStatement(ExecutionContext ec, PreparedStatement ps, Object value, int jdbcPosition, JavaTypeMapping valueMapping) {
        if (!valueMapping.getColumnMapping(0).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        valueMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, valueMapping), value);
        return jdbcPosition + valueMapping.getNumberOfColumnMappings();
    }

    public static int populateElementDiscriminatorInStatement(ExecutionContext ec, PreparedStatement ps, int jdbcPosition, boolean includeSubclasses, ComponentInfo info, ClassLoaderResolver clr) {
        RDBMSStoreManager storeMgr;
        Collection subclasses;
        Object discVal;
        DiscriminatorStrategy strategy = info.getDiscriminatorStrategy();
        JavaTypeMapping discrimMapping = info.getDiscriminatorMapping();
        Class cls = clr.classForName(info.getClassName());
        if (!Modifier.isAbstract(cls.getModifiers()) && (discVal = info.getAbstractClassMetaData().getDiscriminatorValue()) != null) {
            discrimMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, discrimMapping), discVal);
            jdbcPosition += discrimMapping.getNumberOfColumnMappings();
        }
        if (includeSubclasses && (subclasses = (storeMgr = discrimMapping.getStoreManager()).getSubClassesForClass(info.getClassName(), true, clr)) != null && subclasses.size() > 0) {
            for (String subclass : subclasses) {
                Class subcls = clr.classForName(subclass);
                if (Modifier.isAbstract(subcls.getModifiers())) continue;
                AbstractClassMetaData subclassCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(subclass, clr);
                Object discVal2 = subclassCmd.getDiscriminatorValue();
                if (strategy == DiscriminatorStrategy.NONE) continue;
                discrimMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, discrimMapping), discVal2);
                jdbcPosition += discrimMapping.getNumberOfColumnMappings();
            }
        }
        return jdbcPosition;
    }

    public static int populateEmbeddedElementFieldsInStatement(ObjectProvider op, Object element, PreparedStatement ps, int jdbcPosition, AbstractMemberMetaData ownerFieldMetaData, JavaTypeMapping elementMapping, AbstractClassMetaData emd, BaseContainerStore bcs) {
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)elementMapping;
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = emd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfColumnMappings()];
            for (int j = 0; j < fieldMapping.getNumberOfColumnMappings(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        ObjectProvider elementOP = bcs.getObjectProviderForEmbeddedPCObject(op, element, ownerFieldMetaData, (short)2);
        elementOP.provideFields(elementFieldNumbers, (FieldManager)new ParameterSetter(elementOP, ps, mappingDefinition));
        return jdbcPosition;
    }

    public static int populateEmbeddedKeyFieldsInStatement(ObjectProvider op, Object key, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        AbstractClassMetaData kmd = mapStore.getKeyClassMetaData();
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)mapStore.getKeyMapping();
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = kmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfColumnMappings()];
            for (int j = 0; j < fieldMapping.getNumberOfColumnMappings(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        ObjectProvider elementOP = mapStore.getObjectProviderForEmbeddedPCObject(op, key, joinTable.getOwnerMemberMetaData(), (short)3);
        elementOP.provideFields(elementFieldNumbers, (FieldManager)new ParameterSetter(elementOP, ps, mappingDefinition));
        return jdbcPosition;
    }

    public static int populateEmbeddedValueFieldsInStatement(ObjectProvider op, Object value, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        AbstractClassMetaData vmd = mapStore.getValueClassMetaData();
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)mapStore.getValueMapping();
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = vmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfColumnMappings()];
            for (int j = 0; j < fieldMapping.getNumberOfColumnMappings(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        ObjectProvider elementOP = mapStore.getObjectProviderForEmbeddedPCObject(op, value, joinTable.getOwnerMemberMetaData(), (short)4);
        elementOP.provideFields(elementFieldNumbers, (FieldManager)new ParameterSetter(elementOP, ps, mappingDefinition));
        return jdbcPosition;
    }

    public static void appendWhereClauseForElement(StringBuilder stmt, JavaTypeMapping elementMapping, Object element, boolean elementsSerialised, String containerAlias, boolean firstWhereClause) {
        if (!firstWhereClause) {
            stmt.append(" AND ");
        }
        if (elementMapping instanceof ReferenceMapping && elementMapping.getNumberOfColumnMappings() > 1) {
            for (int i = 0; i < elementMapping.getNumberOfColumnMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                if (containerAlias != null) {
                    stmt.append(containerAlias).append(".");
                }
                stmt.append(elementMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
                if (((ReferenceMapping)elementMapping).getJavaTypeMapping()[i].getType().equals(element.getClass().getName())) {
                    if (elementsSerialised) {
                        stmt.append(" LIKE ");
                    } else {
                        stmt.append("=");
                    }
                    stmt.append(elementMapping.getColumnMapping(i).getUpdateInputParameter());
                    continue;
                }
                stmt.append(" IS NULL");
            }
        } else {
            for (int i = 0; i < elementMapping.getNumberOfColumnMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                if (containerAlias != null) {
                    stmt.append(containerAlias).append(".");
                }
                stmt.append(elementMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
                if (elementsSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append("=");
                }
                stmt.append(elementMapping.getColumnMapping(i).getUpdateInputParameter());
            }
        }
    }

    public static void appendWhereClauseForMapping(StringBuilder stmt, JavaTypeMapping mapping, String containerAlias, boolean firstWhereClause) {
        for (int i = 0; i < mapping.getNumberOfColumnMappings(); ++i) {
            if (!firstWhereClause || firstWhereClause && i > 0) {
                stmt.append(" AND ");
            }
            if (containerAlias != null) {
                stmt.append(containerAlias).append(".");
            }
            stmt.append(mapping.getColumnMapping(i).getColumn().getIdentifier().toString());
            stmt.append("=");
            stmt.append(mapping.getColumnMapping(i).getInsertionInputParameter());
        }
    }
}

