/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.mojo.xml.AbstractXmlMojo;
import org.codehaus.mojo.xml.LSInputImpl;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;

public class Resolver
implements EntityResolver2,
URIResolver,
LSResourceResolver {
    private final ResourceManager locator;
    private final File baseDir;
    private final CatalogResolver resolver;
    private boolean validating;
    private boolean xincludeAware;
    private final AbstractXmlMojo.CatalogHandling catalogHandling;

    Resolver(File pBaseDir, List<File> pFiles, List<URL> pUrls, ResourceManager pLocator, AbstractXmlMojo.CatalogHandling catalogHandling, boolean pLogging) throws MojoExecutionException {
        int i;
        this.baseDir = pBaseDir;
        this.locator = pLocator;
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        if (pLogging) {
            System.err.println("Setting resolver verbosity to maximum.");
            manager.setVerbosity(Integer.MAX_VALUE);
        }
        this.resolver = new CatalogResolver(manager);
        for (i = 0; i < pFiles.size(); ++i) {
            File file = pFiles.get(i);
            try {
                this.resolver.getCatalog().parseCatalog(file.getPath());
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse catalog file: " + file.getPath() + ": " + e.getMessage(), (Exception)e);
            }
        }
        for (i = 0; i < pUrls.size(); ++i) {
            URL url = pUrls.get(i);
            try {
                this.resolver.getCatalog().parseCatalog(url);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse catalog URL: " + url + ": " + e.getMessage(), (Exception)e);
            }
        }
        this.catalogHandling = catalogHandling;
    }

    @Override
    public InputSource resolveEntity(String pPublicId, String pSystemId) throws SAXException, IOException {
        InputSource source = this.resolver.resolveEntity(pPublicId, pSystemId);
        if (source != null) {
            return source;
        }
        URL url = this.resolve(pSystemId);
        if (url != null) {
            return this.asInputSource(url);
        }
        return null;
    }

    private InputSource asInputSource(URL url) throws IOException {
        InputSource isource = new InputSource(url.openStream());
        isource.setSystemId(url.toExternalForm());
        return isource;
    }

    @Override
    public Source resolve(String pHref, String pBase) throws TransformerException {
        URL url = null;
        Source source = this.resolver.resolve(pHref, pBase);
        if (source != null) {
            if (this.xincludeAware) {
                try {
                    url = new URI(source.getSystemId()).toURL();
                }
                catch (Exception e) {
                    throw new TransformerException(e);
                }
            } else {
                return source;
            }
        }
        if (null == url) {
            url = this.resolve(pHref);
        }
        if (url != null) {
            try {
                return this.asSaxSource(this.asInputSource(url));
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
            catch (SAXException e) {
                throw new TransformerException(e);
            }
            catch (ParserConfigurationException e) {
                throw new TransformerException(e);
            }
        }
        return null;
    }

    private Source asSaxSource(InputSource isource) throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(this.validating);
        spf.setNamespaceAware(true);
        spf.setXIncludeAware(this.xincludeAware);
        XMLReader xmlReader = spf.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver(this);
        return new SAXSource(xmlReader, isource);
    }

    private final LSInput newLSInput(InputSource pSource) {
        LSInputImpl lsInput = new LSInputImpl();
        lsInput.setByteStream(pSource.getByteStream());
        lsInput.setCharacterStream(pSource.getCharacterStream());
        lsInput.setPublicId(lsInput.getPublicId());
        lsInput.setSystemId(pSource.getSystemId());
        lsInput.setEncoding(pSource.getEncoding());
        return lsInput;
    }

    @Override
    public LSInput resolveResource(String pType, String pNamespaceURI, String pPublicId, String pSystemId, String pBaseURI) {
        URL url;
        InputSource isource;
        if (pPublicId != null && (isource = this.resolver.resolveEntity(pPublicId, pSystemId)) != null) {
            return this.newLSInput(isource);
        }
        isource = this.resolver.resolveEntity(pNamespaceURI, pSystemId);
        if (isource != null) {
            return this.newLSInput(isource);
        }
        URI baseURI = null;
        if (pBaseURI != null) {
            try {
                baseURI = new URI(pBaseURI);
            }
            catch (URISyntaxException ex) {
                baseURI = null;
            }
        }
        if ((url = this.resolve(pSystemId, baseURI)) != null) {
            try {
                isource = this.asInputSource(url);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return isource == null ? null : this.newLSInput(isource);
    }

    public void setValidating(boolean pValidating) {
        this.validating = pValidating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    private URL resolveAsResource(String pResource) {
        return Thread.currentThread().getContextClassLoader().getResource(pResource);
    }

    private URL resolveAsFile(String pResource) {
        File f = new File(this.baseDir, pResource);
        if (!f.isFile() && !(f = new File(pResource)).isFile()) {
            return null;
        }
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL resolveAsURL(String pResource, URI pBaseURI) {
        InputStream stream = null;
        try {
            URL url = new URL(pResource);
            stream = url.openStream();
            stream.close();
            stream = null;
            URL uRL = url;
            return uRL;
        }
        catch (IOException url) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            URI resourceASURI = new URI(pResource);
            if (pBaseURI != null && !resourceASURI.isAbsolute() && pBaseURI.isAbsolute()) {
                resourceASURI = pBaseURI.resolve(resourceASURI);
                URL url = resourceASURI.toURL();
                stream = url.openStream();
                stream.close();
                stream = null;
                URL uRL = url;
                return uRL;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public URL resolve(String pResource) {
        return this.resolve(pResource, (URI)null);
    }

    private URL resolve(String pResource, URI pBaseURI) {
        if (pResource == null) {
            return null;
        }
        if (pResource.startsWith("resource:")) {
            String res = pResource.substring("resource:".length());
            return this.resolveAsResource(res);
        }
        URL url = this.resolveAsResource(pResource);
        if (url == null) {
            url = this.resolveAsURL(pResource, null);
            if (url == null) {
                url = this.resolveAsFile(pResource);
            }
            if (url == null) {
                url = this.resolveAsURL(pResource, pBaseURI);
            }
        }
        if (url == null) {
            return null;
        }
        try {
            return this.locator.getResource(url.toExternalForm()).getURL();
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String pName, String pPublicId, String pBaseURI, String pSystemId) throws SAXException, IOException {
        URL url;
        InputSource source = this.resolver.resolveEntity(pPublicId, pSystemId);
        if (source != null) {
            return source;
        }
        URI baseURI = null;
        if (pBaseURI != null) {
            try {
                baseURI = new URI(pBaseURI);
            }
            catch (URISyntaxException ex) {
                throw new SAXException("Incorrectly formatted base URI", ex);
            }
        }
        if ((url = this.resolve(pSystemId, baseURI)) != null) {
            return this.asInputSource(url);
        }
        return null;
    }

    public boolean isXincludeAware() {
        return this.xincludeAware;
    }

    public void setXincludeAware(boolean pXIncludeAware) {
        this.xincludeAware = pXIncludeAware;
    }

    String filterPossibleURI(String pResource) {
        switch (this.catalogHandling) {
            case strict: {
                return null;
            }
            case local: {
                try {
                    URI resourceAsURI = new URI(pResource);
                    String scheme = resourceAsURI.getScheme();
                    if (scheme != null && !"file".equals(scheme)) {
                        return null;
                    }
                    break;
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }
        }
        return pResource;
    }
}

