/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.license.LicenseMojoUtils;
import org.codehaus.mojo.license.api.FreeMarkerHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.HttpRequester;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=ThirdPartyTool.class, hint="default")
public class DefaultThirdPartyTool
extends AbstractLogEnabled
implements ThirdPartyTool {
    private static final String DESCRIPTOR_CLASSIFIER = "third-party";
    private static final String DESCRIPTOR_TYPE = "properties";
    private static final Pattern GAV_PLUS_TYPE_PATTERN = Pattern.compile("(.+)--(.+)--(.+)--(.+)");
    private static final Pattern GAV_PLUS_TYPE_AND_CLASSIFIER_PATTERN = Pattern.compile("(.+)--(.+)--(.+)--(.+)--(.+)");
    static final String LICENSE_DB_TYPE = "license.properties";
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private MavenProjectHelper projectHelper;
    private FreeMarkerHelper freeMarkerHelper = FreeMarkerHelper.newDefaultHelper();
    private final Comparator<MavenProject> projectComparator = MojoHelper.newMavenProjectComparator();
    private boolean verbose;

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void attachThirdPartyDescriptor(MavenProject project, File file) {
        this.projectHelper.attachArtifact(project, DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER, file);
    }

    @Override
    public SortedSet<MavenProject> getProjectsWithNoLicense(LicenseMap licenseMap, boolean doLog) {
        Logger log = this.getLogger();
        SortedSet unsafeDependencies = (SortedSet)licenseMap.get("Unknown license");
        if (doLog) {
            if (CollectionUtils.isEmpty((Collection)unsafeDependencies)) {
                log.debug("There is no dependency with no license from poms.");
            } else if (log.isDebugEnabled()) {
                boolean plural = unsafeDependencies.size() > 1;
                String message = String.format("There %s %d %s with no license from poms :", plural ? "are" : "is", unsafeDependencies.size(), plural ? "dependencies" : "dependency");
                log.debug(message);
                for (MavenProject dep : unsafeDependencies) {
                    log.debug(" - " + MojoHelper.getArtifactId(dep.getArtifact()));
                }
            }
        }
        return unsafeDependencies;
    }

    @Override
    public SortedProperties loadThirdPartyDescriptorsForUnsafeMapping(Set<Artifact> topLevelDependencies, String encoding, Collection<MavenProject> projects, SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ThirdPartyToolException, IOException {
        SortedProperties result = new SortedProperties(encoding);
        HashMap<String, MavenProject> unsafeProjects = new HashMap<String, MavenProject>();
        for (MavenProject unsafeDependency : unsafeDependencies) {
            String id = MojoHelper.getArtifactId(unsafeDependency.getArtifact());
            unsafeProjects.put(id, unsafeDependency);
        }
        for (MavenProject mavenProject : projects) {
            if (CollectionUtils.isEmpty(unsafeDependencies)) break;
            File thirdPartyDescriptor = this.resolvThirdPartyDescriptor(mavenProject, localRepository, remoteRepositories);
            if (thirdPartyDescriptor == null || !thirdPartyDescriptor.exists() || thirdPartyDescriptor.length() <= 0L) continue;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Detects third party descriptor " + thirdPartyDescriptor);
            }
            SortedProperties unsafeMappings = new SortedProperties(encoding);
            if (thirdPartyDescriptor.exists()) {
                this.getLogger().info("Load missing file " + thirdPartyDescriptor);
                unsafeMappings.load(thirdPartyDescriptor);
            }
            this.resolveUnsafe(unsafeDependencies, licenseMap, unsafeProjects, unsafeMappings, result);
        }
        try {
            this.loadGlobalLicenses(topLevelDependencies, localRepository, remoteRepositories, unsafeDependencies, licenseMap, unsafeProjects, result);
        }
        catch (ArtifactNotFoundException e) {
            throw new ThirdPartyToolException("Failed to load global licenses", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new ThirdPartyToolException("Failed to load global licenses", (Exception)((Object)e));
        }
        return result;
    }

    private void resolveUnsafe(SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, Map<String, MavenProject> unsafeProjects, SortedProperties unsafeMappings, SortedProperties result) {
        for (String id : unsafeProjects.keySet()) {
            String license;
            if (!unsafeMappings.containsKey(id) || StringUtils.isEmpty((CharSequence)(license = (String)unsafeMappings.get(id)))) continue;
            MavenProject resolvedProject = unsafeProjects.get(id);
            unsafeDependencies.remove(resolvedProject);
            result.put(id, license.trim());
            this.addLicense(licenseMap, resolvedProject, license);
        }
    }

    @Override
    public File resolvThirdPartyDescriptor(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws ThirdPartyToolException {
        if (project == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (localRepository == null) {
            throw new IllegalArgumentException("The parameter 'localRepository' can not be null");
        }
        if (repositories == null) {
            throw new IllegalArgumentException("The parameter 'remoteArtifactRepositories' can not be null");
        }
        try {
            return this.resolveThirdPartyDescriptor(project, localRepository, repositories);
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("ArtifactNotFoundException: Unable to locate third party descriptor: " + (Object)((Object)e));
            return null;
        }
        catch (ArtifactResolutionException e) {
            throw new ThirdPartyToolException("ArtifactResolutionException: Unable to locate third party descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ThirdPartyToolException("IOException: Unable to locate third party descriptor: " + e.getMessage(), e);
        }
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, String ... licenseNames) {
        ArrayList<License> licenses = new ArrayList<License>();
        for (String licenseName : licenseNames) {
            License license = new License();
            license.setName(licenseName.trim());
            license.setUrl(licenseName.trim());
            licenses.add(license);
        }
        this.addLicense(licenseMap, project, licenses);
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, License license) {
        this.addLicense(licenseMap, project, Collections.singletonList(license));
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, List<?> licenses) {
        if ("system".equals(project.getArtifact().getScope())) {
            return;
        }
        if (CollectionUtils.isEmpty(licenses)) {
            licenseMap.put("Unknown license", project);
            return;
        }
        for (Object o : licenses) {
            String id = MojoHelper.getArtifactId(project.getArtifact());
            if (o == null) {
                this.getLogger().warn("could not acquire the license for " + id);
                continue;
            }
            License license = (License)o;
            String licenseKey = license.getName();
            if (StringUtils.isEmpty((CharSequence)license.getName())) {
                this.getLogger().warn("The license for " + id + " has no name (but exist)");
                licenseKey = license.getUrl();
            }
            if (StringUtils.isEmpty((CharSequence)licenseKey)) {
                this.getLogger().warn("No license url defined for " + id);
                licenseKey = "Unknown license";
            }
            licenseMap.put(licenseKey, project);
        }
    }

    @Override
    public void mergeLicenses(LicenseMap licenseMap, String mainLicense, Set<String> licenses) {
        if (licenses.isEmpty()) {
            return;
        }
        TreeSet<MavenProject> mainSet = (TreeSet<MavenProject>)licenseMap.get(mainLicense);
        if (mainSet == null) {
            if (this.isVerbose()) {
                this.getLogger().warn("No license [" + mainLicense + "] found, will create it.");
            }
            mainSet = new TreeSet<MavenProject>(this.projectComparator);
            licenseMap.put(mainLicense, mainSet);
        }
        for (String license : licenses) {
            SortedSet set = (SortedSet)licenseMap.get(license);
            if (set == null) {
                if (!this.isVerbose()) continue;
                this.getLogger().warn("No license [" + license + "] found, skip the merge to [" + mainLicense + "]");
                continue;
            }
            if (this.isVerbose()) {
                this.getLogger().info("Merge license [" + license + "] to [" + mainLicense + "] (" + set.size() + " dependencies).");
            }
            mainSet.addAll(set);
            set.clear();
            licenseMap.remove(license);
        }
    }

    @Override
    public SortedProperties loadUnsafeMapping(LicenseMap licenseMap, SortedMap<String, MavenProject> artifactCache, String encoding, File missingFile, String missingFileUrl) throws IOException, MojoExecutionException {
        String id;
        MavenProject mavenProject;
        HashMap<String, MavenProject> snapshots = new HashMap<String, MavenProject>();
        for (Map.Entry<String, MavenProject> entry : artifactCache.entrySet()) {
            mavenProject = entry.getValue();
            if (!mavenProject.getVersion().endsWith("SNAPSHOT")) continue;
            snapshots.put(entry.getKey(), mavenProject);
        }
        for (Map.Entry<String, Object> entry : snapshots.entrySet()) {
            artifactCache.remove(entry.getKey());
            mavenProject = (MavenProject)entry.getValue();
            String id2 = MojoHelper.getArtifactId(mavenProject.getArtifact());
            artifactCache.put(id2, mavenProject);
        }
        SortedSet<MavenProject> unsafeDependencies = this.getProjectsWithNoLicense(licenseMap, false);
        SortedProperties sortedProperties = new SortedProperties(encoding);
        if (missingFile.exists()) {
            this.getLogger().info("Load missing file " + missingFile);
            sortedProperties.load(missingFile);
        }
        if (HttpRequester.isStringUrl(missingFileUrl)) {
            String httpRequestResult = HttpRequester.getFromUrl(missingFileUrl);
            sortedProperties.load(new ByteArrayInputStream(httpRequestResult.getBytes()));
        }
        ArrayList<String> unknownDependenciesId = new ArrayList<String>();
        Map<String, String> migrateKeys = this.migrateMissingFileKeys(sortedProperties.keySet());
        for (String string : migrateKeys.keySet()) {
            id = string;
            String migratedId = migrateKeys.get(id);
            MavenProject project = (MavenProject)artifactCache.get(migratedId);
            if (project == null) {
                unknownDependenciesId.add(id);
                continue;
            }
            if (id.equals(migratedId)) continue;
            this.getLogger().info("Migrates [" + id + "] to [" + migratedId + "] in the missing file.");
            Object value = sortedProperties.get(id);
            sortedProperties.remove(id);
            sortedProperties.put(migratedId, value);
        }
        if (!unknownDependenciesId.isEmpty()) {
            for (String string : unknownDependenciesId) {
                this.getLogger().warn("dependency [" + string + "] does not exist in project, remove it from the missing file.");
                sortedProperties.remove(string);
            }
            unknownDependenciesId.clear();
        }
        for (Object object : sortedProperties.keySet()) {
            id = (String)object;
            MavenProject project = (MavenProject)artifactCache.get(id);
            if (project == null) {
                this.getLogger().warn("dependency [" + id + "] does not exist in project.");
                continue;
            }
            String license = (String)sortedProperties.get(id);
            Object[] licenses = StringUtils.split((String)license, (char)'|');
            if (ArrayUtils.isEmpty((Object[])licenses)) continue;
            this.addLicense(licenseMap, project, (String[])licenses);
            unsafeDependencies.remove(project);
        }
        if (unsafeDependencies.isEmpty()) {
            licenseMap.remove("Unknown license");
        } else {
            for (MavenProject mavenProject2 : unsafeDependencies) {
                id = MojoHelper.getArtifactId(mavenProject2.getArtifact());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("dependency [" + id + "] has no license, add it in the missing file.");
                }
                sortedProperties.setProperty(id, "");
            }
        }
        return sortedProperties;
    }

    @Override
    public void overrideLicenses(LicenseMap licenseMap, SortedMap<String, MavenProject> artifactCache, String encoding, URL overrideUrl) throws IOException {
        if (LicenseMojoUtils.isValid(overrideUrl)) {
            SortedProperties overrideMappings = new SortedProperties(encoding);
            try (InputStream input = overrideUrl.openStream();){
                overrideMappings.load(input);
            }
            for (Object o : overrideMappings.keySet()) {
                String id = (String)o;
                MavenProject project = (MavenProject)artifactCache.get(id);
                if (project == null) {
                    this.getLogger().warn("dependency [" + id + "] does not exist in project.");
                    continue;
                }
                String license = (String)overrideMappings.get(id);
                Object[] licenses = StringUtils.split((String)license, (char)'|');
                if (ArrayUtils.isEmpty((Object[])licenses)) continue;
                licenseMap.removeProject(project);
                this.addLicense(licenseMap, project, (String[])licenses);
            }
        }
    }

    @Override
    public void writeThirdPartyFile(LicenseMap licenseMap, File thirdPartyFile, boolean verbose, String encoding, String lineFormat) throws IOException {
        Logger log = this.getLogger();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("licenseMap", licenseMap.entrySet());
        properties.put("dependencyMap", licenseMap.toDependencyMap().entrySet());
        String content = this.freeMarkerHelper.renderTemplate(lineFormat, properties);
        log.info("Writing third-party file to " + thirdPartyFile);
        if (verbose) {
            log.info(content);
        }
        FileUtil.printString(thirdPartyFile, content, encoding);
    }

    @Override
    public void writeBundleThirdPartyFile(File thirdPartyFile, File outputDirectory, String bundleThirdPartyPath) throws IOException {
        File bundleTarget = FileUtil.getFile(outputDirectory, bundleThirdPartyPath);
        this.getLogger().info("Writing bundled third-party file to " + bundleTarget);
        FileUtil.copyFile(thirdPartyFile, bundleTarget);
    }

    private void loadGlobalLicenses(Set<Artifact> dependencies, ArtifactRepository localRepository, List<ArtifactRepository> repositories, SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, Map<String, MavenProject> unsafeProjects, SortedProperties result) throws IOException, ArtifactNotFoundException, ArtifactResolutionException {
        for (Artifact dep : dependencies) {
            if (!LICENSE_DB_TYPE.equals(dep.getType())) continue;
            this.loadOneGlobalSet(unsafeDependencies, licenseMap, unsafeProjects, dep, localRepository, repositories, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOneGlobalSet(SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, Map<String, MavenProject> unsafeProjects, Artifact dep, ArtifactRepository localRepository, List<ArtifactRepository> repositories, SortedProperties result) throws IOException, ArtifactNotFoundException, ArtifactResolutionException {
        this.artifactResolver.resolve(dep, repositories, localRepository);
        File propFile = dep.getFile();
        this.getLogger().info(String.format("Loading global license map from %s: %s", dep.toString(), propFile.getAbsolutePath()));
        SortedProperties props = new SortedProperties("utf-8");
        FileInputStream propStream = null;
        try {
            propStream = new FileInputStream(propFile);
            props.load(propStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(propStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)propStream);
        for (Object keyObj : props.keySet()) {
            String key = (String)keyObj;
            String val = (String)props.get(key);
            result.put(key, val);
        }
        this.resolveUnsafe(unsafeDependencies, licenseMap, unsafeProjects, props, result);
    }

    private File resolveThirdPartyDescriptor(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        File result;
        try {
            result = this.resolveArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER, localRepository, repositories);
            if (result.length() == 0L) {
                this.getLogger().debug("Skipped third party descriptor");
            }
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("Unable to locate third party files descriptor : " + (Object)((Object)e));
            Artifact artifact = e.getArtifact() == null ? this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER) : e.getArtifact();
            result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
        }
        return result;
    }

    @Override
    public File resolveMissingLicensesDescriptor(String groupId, String artifactId, String version, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveArtifact(groupId, artifactId, version, DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER, localRepository, repositories);
    }

    private File resolveArtifact(String groupId, String artifactId, String version, String type, String classifier, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws ArtifactResolutionException, IOException, ArtifactNotFoundException {
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        this.artifactResolver.resolve(artifact, repositories, localRepository);
        return artifact.getFile();
    }

    private Map<String, String> migrateMissingFileKeys(Set<Object> missingFileKeys) {
        HashMap<String, String> migrateKeys = new HashMap<String, String>();
        for (Object object : missingFileKeys) {
            String id;
            String newId = id = (String)object;
            Matcher matcher = GAV_PLUS_TYPE_AND_CLASSIFIER_PATTERN.matcher(id);
            if (matcher.matches()) {
                newId = matcher.group(1) + "--" + matcher.group(2) + "--" + matcher.group(3);
            } else {
                matcher = GAV_PLUS_TYPE_PATTERN.matcher(id);
                if (matcher.matches()) {
                    newId = matcher.group(1) + "--" + matcher.group(2) + "--" + matcher.group(3);
                }
            }
            migrateKeys.put(id, newId);
        }
        return migrateKeys;
    }
}

