/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.license.utils.HttpRequester;

public final class LicenseMojoUtils {
    static final URL NO_URL;
    static final String DEFAULT_OVERRIDE_THIRD_PARTY = "src/license/override-THIRD-PARTY.properties";

    private LicenseMojoUtils() {
    }

    public static boolean isValid(URL url) {
        return url != null && url != NO_URL;
    }

    static URL prepareThirdPartyOverrideUrl(URL resolvedUrl, File deprecatedFile, String url, File basedir, Log log) {
        if (deprecatedFile != null) {
            log.warn((CharSequence)"'overrideFile' mojo parameter is deprecated. Use 'overrideUrl' instead.");
        }
        return LicenseMojoUtils.prepareUrl(resolvedUrl, deprecatedFile, url, basedir, DEFAULT_OVERRIDE_THIRD_PARTY);
    }

    private static URL prepareUrl(URL resolvedUrl, File deprecatedFile, String url, File basedir, String defaultFilePath) {
        if (resolvedUrl != null && resolvedUrl != NO_URL) {
            return resolvedUrl;
        }
        if (deprecatedFile != null && url != null && !url.isEmpty()) {
            throw new IllegalArgumentException("You can't use both overrideFile and overrideUrl");
        }
        if (deprecatedFile != null && deprecatedFile.exists()) {
            try {
                return deprecatedFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        Path basedirPath = basedir.toPath();
        if (url != null && HttpRequester.isStringUrl(url)) {
            try {
                return new URL(basedirPath.toUri().toURL(), url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        Path defaultPath = basedirPath.resolve(defaultFilePath);
        if (Files.exists(defaultPath, new LinkOption[0])) {
            try {
                return defaultPath.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return NO_URL;
    }

    static {
        try {
            NO_URL = new URL("file:///inexistent");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

