/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.util;

import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class FileFilterHelper {
    private FileFilterHelper() {
    }

    public static IOFileFilter makeDirectoryAware(IOFileFilter filter, String directoryName) {
        IOFileFilter directoryAwareFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.nameFileFilter((String)directoryName)));
        return FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)directoryAwareFilter);
    }

    public static IOFileFilter makeFileNameAware(IOFileFilter filter, String fileName) {
        IOFileFilter directoryAwareFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.nameFileFilter((String)fileName)));
        return FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)directoryAwareFilter);
    }

    public static IOFileFilter makeSuffixAware(IOFileFilter filter, String suffixFileName) {
        IOFileFilter directoryAwareFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)suffixFileName)));
        return FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)directoryAwareFilter);
    }

    public static IOFileFilter makePatternFileNameAware(IOFileFilter filter, String pattern) {
        IOFileFilter directoryAwareFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)new RegexFileFilter(pattern)));
        return FileFilterUtils.andFileFilter((IOFileFilter)filter, (IOFileFilter)directoryAwareFilter);
    }

    public static IOFileFilter createDefaultFilter() {
        IOFileFilter filter = null;
        filter = FileFilterUtils.makeCVSAware(filter);
        filter = FileFilterHelper.makeFileNameAware(filter, ".cvsignore");
        filter = FileFilterUtils.makeSVNAware((IOFileFilter)filter);
        filter = FileFilterHelper.makeDirectoryAware(filter, "RCS");
        filter = FileFilterHelper.makeDirectoryAware(filter, "SCCS");
        filter = FileFilterHelper.makeSuffixAware(filter, "~");
        filter = FileFilterHelper.makePatternFileNameAware(filter, "#.*#");
        filter = FileFilterHelper.makePatternFileNameAware(filter, "%.*%");
        filter = FileFilterHelper.makeSuffixAware(filter, ".#");
        filter = FileFilterHelper.makeSuffixAware(filter, "._");
        filter = FileFilterHelper.makeFileNameAware(filter, "vssver.scc");
        filter = FileFilterHelper.makeFileNameAware(filter, "project.pj");
        filter = FileFilterHelper.makeDirectoryAware(filter, ".arch-ids");
        filter = FileFilterHelper.makeDirectoryAware(filter, ".bzr");
        filter = FileFilterHelper.makeFileNameAware(filter, ".MySCMServerInfo");
        filter = FileFilterHelper.makeDirectoryAware(filter, ".DS_Store");
        filter = FileFilterHelper.makeDirectoryAware(filter, ".metadata");
        filter = FileFilterHelper.makeDirectoryAware(filter, ".hg");
        filter = FileFilterHelper.makeDirectoryAware(filter, ".git");
        filter = FileFilterHelper.makeFileNameAware(filter, ".gitignore");
        filter = FileFilterHelper.makeDirectoryAware(filter, "BitKeeper");
        filter = FileFilterHelper.makeDirectoryAware(filter, "ChangeSet");
        filter = FileFilterHelper.makeDirectoryAware(filter, "_darcs");
        filter = FileFilterHelper.makeDirectoryAware(filter, ".darcsrepo");
        return filter;
    }
}

