/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.camunda.bpm.model.xml.ModelParseException;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.instance.DomDocumentImpl;
import org.camunda.bpm.model.xml.impl.instance.DomElementImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DomUtil {
    public static List<DomElement> filterNodeList(NodeList nodeList, NodeListFilter filter) {
        ArrayList<DomElement> filteredList = new ArrayList<DomElement>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!filter.matches(node)) continue;
            filteredList.add(new DomElementImpl((Element)node));
        }
        return filteredList;
    }

    public static List<DomElement> filterNodeListForElements(NodeList nodeList) {
        return DomUtil.filterNodeList(nodeList, new ElementNodeListFilter());
    }

    public static List<DomElement> filterNodeListByName(NodeList nodeList, String namespaceUri, String localName) {
        return DomUtil.filterNodeList(nodeList, new ElementByNameListFilter(localName, namespaceUri));
    }

    public static List<DomElement> filterNodeListByType(NodeList nodeList, ModelInstanceImpl modelInstance, Class<?> type) {
        return DomUtil.filterNodeList(nodeList, new ElementByTypeListFilter(type, modelInstance));
    }

    public static DomDocument getEmptyDocument(DocumentBuilderFactory documentBuilderFactory) {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return new DomDocumentImpl(documentBuilder.newDocument());
        }
        catch (ParserConfigurationException e) {
            throw new ModelParseException("Unable to create a new document", e);
        }
    }

    public static DomDocument parseInputStream(DocumentBuilderFactory documentBuilderFactory, InputStream inputStream) {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new DomErrorHandler());
            return new DomDocumentImpl(documentBuilder.parse(inputStream));
        }
        catch (ParserConfigurationException e) {
            throw new ModelParseException("ParserConfigurationException while parsing input stream", e);
        }
        catch (SAXException e) {
            throw new ModelParseException("SAXException while parsing input stream", e);
        }
        catch (IOException e) {
            throw new ModelParseException("IOException while parsing input stream", e);
        }
    }

    public static interface NodeListFilter {
        public boolean matches(Node var1);
    }

    public static class ElementNodeListFilter
    implements NodeListFilter {
        @Override
        public boolean matches(Node node) {
            return node.getNodeType() == 1;
        }
    }

    public static class ElementByNameListFilter
    extends ElementNodeListFilter {
        private final String localName;
        private final String namespaceUri;

        public ElementByNameListFilter(String localName, String namespaceUri) {
            this.localName = localName;
            this.namespaceUri = namespaceUri;
        }

        @Override
        public boolean matches(Node node) {
            return super.matches(node) && this.localName.equals(node.getLocalName()) && this.namespaceUri.equals(node.getNamespaceURI());
        }
    }

    public static class ElementByTypeListFilter
    extends ElementNodeListFilter {
        private final Class<?> type;
        private final ModelInstanceImpl model;

        public ElementByTypeListFilter(Class<?> type, ModelInstanceImpl modelInstance) {
            this.type = type;
            this.model = modelInstance;
        }

        @Override
        public boolean matches(Node node) {
            if (!super.matches(node)) {
                return false;
            }
            ModelElementInstance modelElement = ModelUtil.getModelElement(new DomElementImpl((Element)node), this.model);
            return this.type.isAssignableFrom(modelElement.getClass());
        }
    }

    public static class DomErrorHandler
    implements ErrorHandler {
        private static final Logger LOGGER = Logger.getLogger(DomErrorHandler.class.getName());

        private String getParseExceptionInfo(SAXParseException spe) {
            return "URI=" + spe.getSystemId() + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
        }

        @Override
        public void warning(SAXParseException spe) {
            LOGGER.warning(this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

