/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.camunda.bpm.engine.impl.pvm.process.HasDIBounds;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;

public class ActivityImpl
extends ScopeImpl
implements PvmActivity,
HasDIBounds {
    private static final long serialVersionUID = 1L;
    protected List<TransitionImpl> outgoingTransitions = new ArrayList<TransitionImpl>();
    protected Map<String, TransitionImpl> namedOutgoingTransitions = new HashMap<String, TransitionImpl>();
    protected List<TransitionImpl> incomingTransitions = new ArrayList<TransitionImpl>();
    protected ActivityBehavior activityBehavior;
    protected ActivityStartBehavior activityStartBehavior = ActivityStartBehavior.DEFAULT;
    protected ScopeImpl eventScope;
    protected ScopeImpl flowScope;
    protected boolean isScope = false;
    protected boolean isAsyncBefore;
    protected boolean isAsyncAfter;
    protected int x = -1;
    protected int y = -1;
    protected int width = -1;
    protected int height = -1;
    protected AsyncBeforeUpdate delegateAsyncBeforeUpdate;
    protected AsyncAfterUpdate delegateAsyncAfterUpdate;

    public ActivityImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id, processDefinition);
    }

    public TransitionImpl createOutgoingTransition() {
        return this.createOutgoingTransition(null);
    }

    public TransitionImpl createOutgoingTransition(String transitionId) {
        TransitionImpl transition = new TransitionImpl(transitionId, this.processDefinition);
        transition.setSource(this);
        this.outgoingTransitions.add(transition);
        if (transitionId != null) {
            if (this.namedOutgoingTransitions.containsKey(transitionId)) {
                throw new PvmException("activity '" + this.id + " has duplicate transition '" + transitionId + "'");
            }
            this.namedOutgoingTransitions.put(transitionId, transition);
        }
        return transition;
    }

    @Override
    public TransitionImpl findOutgoingTransition(String transitionId) {
        return this.namedOutgoingTransitions.get(transitionId);
    }

    @Override
    public String toString() {
        return "Activity(" + this.id + ")";
    }

    protected void setOutgoingTransitions(List<TransitionImpl> outgoingTransitions) {
        this.outgoingTransitions = outgoingTransitions;
    }

    protected void setIncomingTransitions(List<TransitionImpl> incomingTransitions) {
        this.incomingTransitions = incomingTransitions;
    }

    @Override
    public List<PvmTransition> getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    @Override
    public ActivityBehavior getActivityBehavior() {
        return this.activityBehavior;
    }

    public void setActivityBehavior(ActivityBehavior activityBehavior) {
        this.activityBehavior = activityBehavior;
    }

    @Override
    public ActivityStartBehavior getActivityStartBehavior() {
        return this.activityStartBehavior;
    }

    public void setActivityStartBehavior(ActivityStartBehavior activityStartBehavior) {
        this.activityStartBehavior = activityStartBehavior;
    }

    @Override
    public List<PvmTransition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public boolean isAsyncBefore() {
        return this.isAsyncBefore;
    }

    public void setAsyncBefore(boolean isAsyncBefore) {
        this.setAsyncBefore(isAsyncBefore, true);
    }

    public void setAsyncBefore(boolean isAsyncBefore, boolean exclusive) {
        if (this.delegateAsyncBeforeUpdate != null) {
            this.delegateAsyncBeforeUpdate.updateAsyncBefore(isAsyncBefore, exclusive);
        }
        this.isAsyncBefore = isAsyncBefore;
    }

    @Override
    public boolean isAsyncAfter() {
        return this.isAsyncAfter;
    }

    public void setAsyncAfter(boolean isAsyncAfter) {
        this.setAsyncAfter(isAsyncAfter, true);
    }

    public void setAsyncAfter(boolean isAsyncAfter, boolean exclusive) {
        if (this.delegateAsyncAfterUpdate != null) {
            this.delegateAsyncAfterUpdate.updateAsyncAfter(isAsyncAfter, exclusive);
        }
        this.isAsyncAfter = isAsyncAfter;
    }

    public String getActivityId() {
        return super.getId();
    }

    @Override
    public ScopeImpl getFlowScope() {
        return this.flowScope;
    }

    @Override
    public ScopeImpl getEventScope() {
        return this.eventScope;
    }

    public void setEventScope(ScopeImpl eventScope) {
        if (this.eventScope != null) {
            this.eventScope.eventActivities.remove(this);
        }
        this.eventScope = eventScope;
        if (eventScope != null) {
            this.eventScope.eventActivities.add(this);
        }
    }

    @Override
    public PvmScope getLevelOfSubprocessScope() {
        ScopeImpl levelOfSubprocessScope = this.getFlowScope();
        while (!levelOfSubprocessScope.isSubProcessScope) {
            levelOfSubprocessScope = ((PvmActivity)((Object)levelOfSubprocessScope)).getFlowScope();
        }
        return levelOfSubprocessScope;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    public ActivityImpl getParentFlowScopeActivity() {
        ScopeImpl flowScope = this.getFlowScope();
        if (flowScope != this.getProcessDefinition()) {
            return (ActivityImpl)flowScope;
        }
        return null;
    }

    public boolean isCompensationHandler() {
        Boolean isForCompensation = (Boolean)this.getProperty("isForCompensation");
        return Boolean.TRUE.equals(isForCompensation);
    }

    public ActivityImpl findCompensationHandler() {
        String compensationHandlerId = (String)this.getProperty("compensationHandler");
        if (compensationHandlerId != null) {
            return this.getProcessDefinition().findActivity(compensationHandlerId);
        }
        return null;
    }

    public boolean isMultiInstance() {
        Boolean isMultiInstance = (Boolean)this.getProperty("isMultiInstance");
        return Boolean.TRUE.equals(isMultiInstance);
    }

    public boolean isTriggeredByEvent() {
        Boolean isTriggeredByEvent = this.getProperties().get(BpmnProperties.TRIGGERED_BY_EVENT);
        return Boolean.TRUE.equals(isTriggeredByEvent);
    }

    public AsyncBeforeUpdate getDelegateAsyncBeforeUpdate() {
        return this.delegateAsyncBeforeUpdate;
    }

    public void setDelegateAsyncBeforeUpdate(AsyncBeforeUpdate delegateAsyncBeforeUpdate) {
        this.delegateAsyncBeforeUpdate = delegateAsyncBeforeUpdate;
    }

    public AsyncAfterUpdate getDelegateAsyncAfterUpdate() {
        return this.delegateAsyncAfterUpdate;
    }

    public void setDelegateAsyncAfterUpdate(AsyncAfterUpdate delegateAsyncAfterUpdate) {
        this.delegateAsyncAfterUpdate = delegateAsyncAfterUpdate;
    }

    public static interface AsyncBeforeUpdate {
        public void updateAsyncBefore(boolean var1, boolean var2);
    }

    public static interface AsyncAfterUpdate {
        public void updateAsyncAfter(boolean var1, boolean var2);
    }
}

