/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.util.CharsetUtil;

public class FileReader
extends Task<List<File>, Map<File, String>> {
    private Charset charset = CharsetUtil.getUtf8OrDefault();

    public FileReader charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    protected Map<File, String> process(List<File> input) throws Exception {
        HashMap<File, String> fileContents = new HashMap<File, String>();
        for (File file : input) {
            String content = this.readFile(file);
            fileContents.put(file, content);
        }
        return fileContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        FileInputStream inputStream = null;
        ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
        try {
            int read;
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            while ((read = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1) {
                contentStream.write(buffer, 0, read);
            }
            contentStream.flush();
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        return new String(contentStream.toByteArray(), this.charset);
    }
}

