/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DropTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001>\u0011\u0001\u0003\u0012:paR\u000b'\r\\3D_6l\u0017M\u001c3\u000b\u0005\r!\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"D\b\u0013\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u00037qi\u0011AA\u0005\u0003;\t\u0011qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b!J|G-^2u!\tyR%\u0003\u0002'A\ta1+\u001a:jC2L'0\u00192mK\"A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0011&A\u0005uC\ndWMT1nKV\t!\u0006\u0005\u0002,Y5\ta#\u0003\u0002.-\tyA+\u00192mK&#WM\u001c;jM&,'\u000f\u0003\u00050\u0001\tE\t\u0015!\u0003+\u0003)!\u0018M\u00197f\u001d\u0006lW\r\t\u0005\tc\u0001\u0011)\u001a!C\u0001e\u0005A\u0011NZ#ySN$8/F\u00014!\tyB'\u0003\u00026A\t9!i\\8mK\u0006t\u0007\u0002C\u001c\u0001\u0005#\u0005\u000b\u0011B\u001a\u0002\u0013%4W\t_5tiN\u0004\u0003\u0002C\u001d\u0001\u0005+\u0007I\u0011\u0001\u001a\u0002\r%\u001ch+[3x\u0011!Y\u0004A!E!\u0002\u0013\u0019\u0014aB5t-&,w\u000f\t\u0005\t{\u0001\u0011)\u001a!C\u0001e\u0005)\u0001/\u001e:hK\"Aq\b\u0001B\tB\u0003%1'\u0001\u0004qkJ<W\r\t\u0005\u0006\u0003\u0002!\tAQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\r#UIR$\u0011\u0005m\u0001\u0001\"\u0002\u0015A\u0001\u0004Q\u0003\"B\u0019A\u0001\u0004\u0019\u0004\"B\u001dA\u0001\u0004\u0019\u0004\"B\u001fA\u0001\u0004\u0019\u0004\"B%\u0001\t\u0003R\u0015a\u0001:v]R\u00111j\u0017\t\u0004\u0019R;fBA'S\u001d\tq\u0015+D\u0001P\u0015\t\u0001f\"\u0001\u0004=e>|GOP\u0005\u0002C%\u00111\u000bI\u0001\ba\u0006\u001c7.Y4f\u0013\t)fKA\u0002TKFT!a\u0015\u0011\u0011\u0005aKV\"\u0001\u0004\n\u0005i3!a\u0001*po\")A\f\u0013a\u0001;\u0006a1\u000f]1sWN+7o]5p]B\u0011\u0001LX\u0005\u0003?\u001a\u0011Ab\u00159be.\u001cVm]:j_:Dq!\u0019\u0001\u0002\u0002\u0013\u0005!-\u0001\u0003d_BLH#B\"dI\u00164\u0007b\u0002\u0015a!\u0003\u0005\rA\u000b\u0005\bc\u0001\u0004\n\u00111\u00014\u0011\u001dI\u0004\r%AA\u0002MBq!\u00101\u0011\u0002\u0003\u00071\u0007C\u0004i\u0001E\u0005I\u0011A5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t!N\u000b\u0002+W.\nA\u000e\u0005\u0002ne6\taN\u0003\u0002pa\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003c\u0002\n!\"\u00198o_R\fG/[8o\u0013\t\u0019hNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq!\u001e\u0001\u0012\u0002\u0013\u0005a/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003]T#aM6\t\u000fe\u0004\u0011\u0013!C\u0001m\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004bB>\u0001#\u0003%\tA^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011\u001di\b!!A\u0005By\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A.\u00198h\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011aa\u0015;sS:<\u0007\"CA\t\u0001\u0005\u0005I\u0011AA\n\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0002E\u0002 \u0003/I1!!\u0007!\u0005\rIe\u000e\u001e\u0005\n\u0003;\u0001\u0011\u0011!C\u0001\u0003?\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\"\u0005\u001d\u0002cA\u0010\u0002$%\u0019\u0011Q\u0005\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002*\u0005m\u0011\u0011!a\u0001\u0003+\t1\u0001\u001f\u00132\u0011%\ti\u0003AA\u0001\n\u0003\ny#A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0004\u0005\u0004\u00024\u0005e\u0012\u0011E\u0007\u0003\u0003kQ1!a\u000e!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\t)D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ty\u0004AA\u0001\n\u0003\t\t%\u0001\u0005dC:,\u0015/^1m)\r\u0019\u00141\t\u0005\u000b\u0003S\ti$!AA\u0002\u0005\u0005\u0002\"CA$\u0001\u0005\u0005I\u0011IA%\u0003\u0019)\u0017/^1mgR\u00191'a\u0013\t\u0015\u0005%\u0012QIA\u0001\u0002\u0004\t\tcB\u0005\u0002P\t\t\t\u0011#\u0001\u0002R\u0005\u0001BI]8q)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u00047\u0005Mc\u0001C\u0001\u0003\u0003\u0003E\t!!\u0016\u0014\u000b\u0005M\u0013q\u000b\u0013\u0011\u0013\u0005e\u0013q\f\u00164gM\u001aUBAA.\u0015\r\ti\u0006I\u0001\beVtG/[7f\u0013\u0011\t\t'a\u0017\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007C\u0004B\u0003'\"\t!!\u001a\u0015\u0005\u0005E\u0003BCA5\u0003'\n\t\u0011\"\u0012\u0002l\u0005AAo\\*ue&tw\rF\u0001\u0000\u0011)\ty'a\u0015\u0002\u0002\u0013\u0005\u0015\u0011O\u0001\u0006CB\u0004H.\u001f\u000b\n\u0007\u0006M\u0014QOA<\u0003sBa\u0001KA7\u0001\u0004Q\u0003BB\u0019\u0002n\u0001\u00071\u0007\u0003\u0004:\u0003[\u0002\ra\r\u0005\u0007{\u00055\u0004\u0019A\u001a\t\u0015\u0005u\u00141KA\u0001\n\u0003\u000by(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0015Q\u0012\t\u0006?\u0005\r\u0015qQ\u0005\u0004\u0003\u000b\u0003#AB(qi&|g\u000eE\u0004 \u0003\u0013S3gM\u001a\n\u0007\u0005-\u0005E\u0001\u0004UkBdW\r\u000e\u0005\n\u0003\u001f\u000bY(!AA\u0002\r\u000b1\u0001\u001f\u00131\u0011)\t\u0019*a\u0015\u0002\u0002\u0013%\u0011QS\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0018B!\u0011\u0011AAM\u0013\u0011\tY*a\u0001\u0003\r=\u0013'.Z2u\u0001")
public class DropTableCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean ifExists;
    private final boolean isView;
    private final boolean purge;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Object, Object, Object>> unapply(DropTableCommand dropTableCommand) {
        return DropTableCommand$.MODULE$.unapply(dropTableCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, Object>, DropTableCommand> tupled() {
        return DropTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<Object, DropTableCommand>>>> curried() {
        return DropTableCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        DropTableCommand dropTableCommand = this;
        synchronized (dropTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand$class.metrics(this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean purge() {
        return this.purge;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog2 = sparkSession.sessionState().catalog();
        boolean isTempView = catalog2.isTemporaryTable(this.tableName());
        if (!isTempView && catalog2.tableExists(this.tableName())) {
            CatalogTableType catalogTableType = catalog2.getTableMetadata(this.tableName()).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !this.isView()) {
                throw new AnalysisException("Cannot drop a view with DROP TABLE. Please use DROP VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && this.isView()) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot drop a table with DROP VIEW. Please use DROP TABLE instead"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (!isTempView && !catalog2.tableExists(this.tableName())) {
            if (this.ifExists()) return (Seq)Seq$.MODULE$.empty();
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table or view not found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName().identifier()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        } else {
            try {
                sparkSession.sharedState().cacheManager().uncacheQuery(sparkSession.table(this.tableName()), !isTempView, sparkSession.sharedState().cacheManager().uncacheQuery$default$3());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().warn(e.toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catalog2.refreshTable(this.tableName());
            catalog2.dropTable(this.tableName(), this.ifExists(), this.purge());
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public DropTableCommand copy(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge2) {
        return new DropTableCommand(tableName, ifExists, isView, purge2);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public boolean copy$default$4() {
        return this.purge();
    }

    public String productPrefix() {
        return "DropTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purge());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 0: {
                object = this.tableName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropTableCommand dropTableCommand = (DropTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = dropTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.ifExists() != dropTableCommand.ifExists()) return false;
        if (this.isView() != dropTableCommand.isView()) return false;
        if (this.purge() != dropTableCommand.purge()) return false;
        if (!dropTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropTableCommand(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge2) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.isView = isView;
        this.purge = purge2;
        Command.class.$init$((Command)this);
        RunnableCommand$class.$init$(this);
    }
}

