/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.util.CallSite;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class SQLExecution$ {
    public static final SQLExecution$ MODULE$;
    private final String EXECUTION_ID_KEY;
    private final AtomicLong _nextExecutionId;

    static {
        new SQLExecution$();
    }

    public String EXECUTION_ID_KEY() {
        return this.EXECUTION_ID_KEY;
    }

    private AtomicLong _nextExecutionId() {
        return this._nextExecutionId;
    }

    private long nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public <T> T withNewExecutionId(SparkSession sparkSession, QueryExecution queryExecution, Function0<T> body) {
        SparkContext sc = sparkSession.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        if (oldExecutionId == null) {
            long executionId = this.nextExecutionId();
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)executionId)).toString());
            CallSite callSite = sparkSession.sparkContext().getCallSite();
            sparkSession.sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionStart(executionId, callSite.shortForm(), callSite.longForm(), queryExecution.toString(), SparkPlanInfo$.MODULE$.fromSparkPlan(queryExecution.executedPlan()), System.currentTimeMillis()));
            Object object = body.apply();
            sparkSession.sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionEnd(executionId, System.currentTimeMillis()));
            Object r2 = object;
            return (T)r2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is already set"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.EXECUTION_ID_KEY()})));
        {
            catch (Throwable throwable) {
                void var6_6;
                sparkSession.sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionEnd((long)var6_6, System.currentTimeMillis()));
                throw throwable;
            }
        }
        finally {
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withExecutionId(SparkContext sc, String executionId, Function0<T> body) {
        Object object;
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        try {
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), executionId);
            object = body.apply();
        }
        catch (Throwable throwable) {
            void var4_4;
            sc.setLocalProperty(this.EXECUTION_ID_KEY(), (String)var4_4);
            throw throwable;
        }
        sc.setLocalProperty(this.EXECUTION_ID_KEY(), oldExecutionId);
        return (T)object;
    }

    private SQLExecution$() {
        MODULE$ = this;
        this.EXECUTION_ID_KEY = "spark.sql.execution.id";
        this._nextExecutionId = new AtomicLong(0L);
    }
}

