/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.BooleanEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class HavingStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private BooleanEvaluator evaluator;
    private transient Tuple currentGroupHead;

    public HavingStream(TupleStream stream, BooleanEvaluator evaluator) throws IOException {
        this.init(stream, evaluator);
    }

    public HavingStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        List<StreamExpression> evaluatorExpressions = factory.getExpressionOperandsRepresentingTypes(expression, BooleanEvaluator.class);
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        StreamEvaluator evaluator = null;
        if (evaluatorExpressions != null && evaluatorExpressions.size() == 1) {
            StreamExpression ex = evaluatorExpressions.get(0);
            evaluator = factory.constructEvaluator(ex);
            if (!(evaluator instanceof BooleanEvaluator)) {
                throw new IOException("The HavingStream requires a BooleanEvaluator. A StreamEvaluator was provided.");
            }
        } else {
            throw new IOException("The HavingStream requires a BooleanEvaluator.");
        }
        this.init(factory.constructStream(streamExpressions.get(0)), (BooleanEvaluator)evaluator);
    }

    private void init(TupleStream stream, BooleanEvaluator evaluator) throws IOException {
        this.stream = stream;
        this.evaluator = evaluator;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        if (!(this.evaluator instanceof Expressible)) {
            throw new IOException("This HavingStream contains a non-expressible evaluator - it cannot be converted to an expression");
        }
        expression.addParameter(this.evaluator.toExpression(factory));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString()).withHelpers(new Explanation[]{this.evaluator.toExplanation(factory)});
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.stream.open();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple;
        do {
            tuple = this.stream.read();
            if (!tuple.EOF) continue;
            return tuple;
        } while (!this.evaluator.evaluate(tuple).booleanValue());
        return tuple;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

