/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.properties.StandardReadableProperties;

public class BootstrapProperties
extends StandardReadableProperties {
    private static final String PROPERTY_KEY_FORMAT = "%s.%s";
    private final String propertyPrefix;
    private final Path configFilePath;
    public static final BootstrapProperties EMPTY = new BootstrapProperties("", new Properties(), Paths.get("conf/bootstrap.conf", new String[0])){

        @Override
        public Set<String> getPropertyKeys() {
            return null;
        }

        @Override
        public String getProperty(String key) {
            return null;
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public BootstrapProperties(String propertyPrefix, Properties properties, Path configFilePath) {
        super(new Properties());
        Objects.requireNonNull(properties, "Properties are required");
        this.propertyPrefix = Objects.requireNonNull(propertyPrefix, "Property prefix is required");
        this.configFilePath = configFilePath;
        this.filterProperties(properties);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = super.getProperty(key, defaultValue);
        return BootstrapProperties.isBlank(property) ? null : property;
    }

    @Override
    public String getProperty(String key) {
        String property = super.getProperty(key);
        return BootstrapProperties.isBlank(property) ? null : property;
    }

    public Path getConfigFilePath() {
        return this.configFilePath;
    }

    private void filterProperties(Properties properties) {
        this.getRawProperties().clear();
        Properties filteredProperties = new Properties();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (!key.startsWith(this.propertyPrefix)) continue;
            filteredProperties.put(key, properties.getProperty(key));
        }
        this.getRawProperties().putAll((Map<?, ?>)filteredProperties);
    }

    private String getPropertyKey(String subKey) {
        return String.format(PROPERTY_KEY_FORMAT, this.propertyPrefix, subKey);
    }

    public Optional<String> getProperty(BootstrapPropertyKey key) {
        return Optional.ofNullable(this.getProperty(this.getPropertyKey(key.key)));
    }

    public String toString() {
        return String.format("Bootstrap properties [%s] with prefix [%s]", this.configFilePath, this.propertyPrefix);
    }

    private static boolean isBlank(String string) {
        return string == null || string.isEmpty() || string.trim().isEmpty();
    }

    public static enum BootstrapPropertyKey {
        SENSITIVE_KEY("bootstrap.sensitive.key"),
        HASHICORP_VAULT_SENSITIVE_PROPERTY_PROVIDER_CONF("bootstrap.protection.hashicorp.vault.conf");

        private final String key;

        private BootstrapPropertyKey(String key) {
            this.key = key;
        }
    }
}

