/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import org.apache.nifi.properties.BootstrapProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBootstrapPropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBootstrapPropertiesLoader.class);
    private static final String RELATIVE_APPLICATION_PROPERTIES_PATTERN = "conf/%s";
    private static final String BOOTSTRAP_CONF = "bootstrap.conf";

    protected abstract String getApplicationPrefix();

    protected abstract String getApplicationPropertiesFilename();

    protected abstract String getApplicationPropertiesFilePathSystemProperty();

    public String extractKeyFromBootstrapFile() throws IOException {
        return this.extractKeyFromBootstrapFile(null);
    }

    public BootstrapProperties loadBootstrapProperties(String bootstrapPath) throws IOException {
        Path bootstrapFilePath = this.getBootstrapFile(bootstrapPath).toPath();
        return AbstractBootstrapPropertiesLoader.loadBootstrapProperties(bootstrapFilePath, this.getApplicationPrefix());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BootstrapProperties loadBootstrapProperties(Path bootstrapPath, String propertyPrefix) throws IOException {
        Objects.requireNonNull(bootstrapPath, "Bootstrap path must be provided");
        Objects.requireNonNull(propertyPrefix, "Property prefix must be provided");
        Properties properties = new Properties();
        try (InputStream bootstrapInput = Files.newInputStream(bootstrapPath, new OpenOption[0]);){
            properties.load(bootstrapInput);
            BootstrapProperties bootstrapProperties = new BootstrapProperties(propertyPrefix, properties, bootstrapPath);
            return bootstrapProperties;
        }
        catch (IOException e) {
            throw new IOException("Cannot read from " + bootstrapPath, e);
        }
    }

    public String extractKeyFromBootstrapFile(String bootstrapPath) throws IOException {
        BootstrapProperties bootstrapProperties = this.loadBootstrapProperties(bootstrapPath);
        return bootstrapProperties.getProperty(BootstrapProperties.BootstrapPropertyKey.SENSITIVE_KEY).orElseGet(() -> {
            logger.warn("No encryption key present in the bootstrap.conf file at {}", (Object)bootstrapProperties.getConfigFilePath());
            return "";
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getBootstrapFile(String bootstrapPath) throws IOException {
        File expectedBootstrapFile;
        if (bootstrapPath == null) {
            String defaultApplicationPropertiesFilePath = this.getDefaultApplicationPropertiesFilePath();
            File propertiesFile = new File(defaultApplicationPropertiesFilePath);
            File confDir = new File(propertiesFile.getParent());
            if (!confDir.exists() || !confDir.canRead()) throw new IOException(String.format("Cannot read %s directory for %s", confDir, bootstrapPath));
            expectedBootstrapFile = new File(confDir, BOOTSTRAP_CONF);
        } else {
            expectedBootstrapFile = new File(bootstrapPath);
        }
        if (!expectedBootstrapFile.exists() || !expectedBootstrapFile.canRead()) throw new IOException("Cannot read from " + expectedBootstrapFile.getAbsolutePath());
        return expectedBootstrapFile;
    }

    public String getDefaultApplicationPropertiesFilePath() {
        String systemPropertyName = this.getApplicationPropertiesFilePathSystemProperty();
        String defaultRelativePath = String.format(RELATIVE_APPLICATION_PROPERTIES_PATTERN, this.getApplicationPropertiesFilename());
        String systemPath = System.getProperty(systemPropertyName);
        if (systemPath == null || systemPath.trim().isEmpty()) {
            logger.warn("The system property {} is not set, so it is being set to '{}'", (Object)systemPropertyName, (Object)defaultRelativePath);
            System.setProperty(systemPropertyName, defaultRelativePath);
            systemPath = defaultRelativePath;
        }
        logger.info("Determined default application properties path to be '{}'", (Object)systemPath);
        return systemPath;
    }
}

