/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.Entity;

@XmlType(name="componentRunStatus")
public abstract class ComponentRunStatusEntity
extends Entity {
    private RevisionDTO revision;
    private String state;
    private Boolean disconnectedNodeAcknowledged;

    @ApiModelProperty(value="The revision for this request/response. The revision is required for any mutable flow requests and is included in all responses.")
    public RevisionDTO getRevision() {
        return this.revision;
    }

    public void setRevision(RevisionDTO revision) {
        this.revision = revision;
    }

    @ApiModelProperty(value="The run status of the component.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @ApiModelProperty(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.")
    public Boolean isDisconnectedNodeAcknowledged() {
        return this.disconnectedNodeAcknowledged;
    }

    public void setDisconnectedNodeAcknowledged(Boolean disconnectedNodeAcknowledged) {
        this.disconnectedNodeAcknowledged = disconnectedNodeAcknowledged;
    }

    protected abstract String[] getSupportedState();

    public void validateState() {
        if (this.state == null || this.state.isEmpty()) {
            throw new IllegalArgumentException("The desired state is not set.");
        }
        if (Arrays.stream(this.getSupportedState()).noneMatch(this.state::equals)) {
            throw new IllegalArgumentException(String.format("The desired state '%s' is not supported.", this.state));
        }
    }
}

