/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.status.ConnectionStatusPredictionsSnapshotDTO;

@XmlType(name="connectionStatusSnapshot")
public class ConnectionStatusSnapshotDTO
implements Cloneable {
    private String id;
    private String groupId;
    private String name;
    private String sourceId;
    private String sourceName;
    private String destinationId;
    private String destinationName;
    private ConnectionStatusPredictionsSnapshotDTO predictions;
    private Integer flowFilesIn = 0;
    private Long bytesIn = 0L;
    private String input;
    private Integer flowFilesOut = 0;
    private Long bytesOut = 0L;
    private String output;
    private Integer flowFilesQueued = 0;
    private Long bytesQueued = 0L;
    private String queued;
    private String queuedSize;
    private String queuedCount;
    private Integer percentUseCount;
    private Integer percentUseBytes;

    @ApiModelProperty(value="The id of the connection.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The id of the process group the connection belongs to.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The name of the connection.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The number of flowfiles that are queued, pretty printed.")
    public String getQueuedCount() {
        return this.queuedCount;
    }

    public void setQueuedCount(String queuedCount) {
        this.queuedCount = queuedCount;
    }

    @ApiModelProperty(value="The total size of flowfiles that are queued formatted.")
    public String getQueuedSize() {
        return this.queuedSize;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setQueued(String queued) {
        this.queued = queued;
    }

    public void setQueuedSize(String queuedSize) {
        this.queuedSize = queuedSize;
    }

    @ApiModelProperty(value="The total count and size of queued flowfiles formatted.")
    public String getQueued() {
        return this.queued;
    }

    @ApiModelProperty(value="The id of the source of the connection.")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @ApiModelProperty(value="The name of the source of the connection.")
    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @ApiModelProperty(value="The id of the destination of the connection.")
    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    @ApiModelProperty(value="The name of the destination of the connection.")
    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    @ApiModelProperty(value="Predictions, if available, for this connection (null if not available)")
    public ConnectionStatusPredictionsSnapshotDTO getPredictions() {
        return this.predictions;
    }

    public void setPredictions(ConnectionStatusPredictionsSnapshotDTO predictions) {
        this.predictions = predictions;
    }

    @ApiModelProperty(value="The input count/size for the connection in the last 5 minutes, pretty printed.")
    public String getInput() {
        return this.input;
    }

    @ApiModelProperty(value="The output count/sie for the connection in the last 5 minutes, pretty printed.")
    public String getOutput() {
        return this.output;
    }

    @ApiModelProperty(value="The number of FlowFiles that have come into the connection in the last 5 minutes.")
    public Integer getFlowFilesIn() {
        return this.flowFilesIn;
    }

    public void setFlowFilesIn(Integer flowFilesIn) {
        this.flowFilesIn = flowFilesIn;
    }

    @ApiModelProperty(value="The size of the FlowFiles that have come into the connection in the last 5 minutes.")
    public Long getBytesIn() {
        return this.bytesIn;
    }

    public void setBytesIn(Long bytesIn) {
        this.bytesIn = bytesIn;
    }

    @ApiModelProperty(value="The number of FlowFiles that have left the connection in the last 5 minutes.")
    public Integer getFlowFilesOut() {
        return this.flowFilesOut;
    }

    public void setFlowFilesOut(Integer flowFilesOut) {
        this.flowFilesOut = flowFilesOut;
    }

    @ApiModelProperty(value="The number of bytes that have left the connection in the last 5 minutes.")
    public Long getBytesOut() {
        return this.bytesOut;
    }

    public void setBytesOut(Long bytesOut) {
        this.bytesOut = bytesOut;
    }

    @ApiModelProperty(value="The number of FlowFiles that are currently queued in the connection.")
    public Integer getFlowFilesQueued() {
        return this.flowFilesQueued;
    }

    public void setFlowFilesQueued(Integer flowFilesQueued) {
        this.flowFilesQueued = flowFilesQueued;
    }

    @ApiModelProperty(value="The size of the FlowFiles that are currently queued in the connection.")
    public Long getBytesQueued() {
        return this.bytesQueued;
    }

    public void setBytesQueued(Long bytesQueued) {
        this.bytesQueued = bytesQueued;
    }

    @ApiModelProperty(value="Connection percent use regarding queued flow files count and backpressure threshold if configured.")
    public Integer getPercentUseCount() {
        return this.percentUseCount;
    }

    public void setPercentUseCount(Integer percentUseCount) {
        this.percentUseCount = percentUseCount;
    }

    @ApiModelProperty(value="Connection percent use regarding queued flow files size and backpressure threshold if configured.")
    public Integer getPercentUseBytes() {
        return this.percentUseBytes;
    }

    public void setPercentUseBytes(Integer percentUseBytes) {
        this.percentUseBytes = percentUseBytes;
    }

    public ConnectionStatusSnapshotDTO clone() {
        ConnectionStatusSnapshotDTO other = new ConnectionStatusSnapshotDTO();
        other.setDestinationId(this.getDestinationId());
        other.setDestinationName(this.getDestinationName());
        other.setGroupId(this.getGroupId());
        other.setId(this.getId());
        other.setName(this.getName());
        other.setSourceId(this.getSourceId());
        other.setSourceName(this.getSourceName());
        if (this.predictions != null) {
            other.setPredictions(this.predictions.clone());
        }
        other.setFlowFilesIn(this.getFlowFilesIn());
        other.setBytesIn(this.getBytesIn());
        other.setInput(this.getInput());
        other.setFlowFilesOut(this.getFlowFilesOut());
        other.setBytesOut(this.getBytesOut());
        other.setOutput(this.getOutput());
        other.setFlowFilesQueued(this.getFlowFilesQueued());
        other.setBytesQueued(this.getBytesQueued());
        other.setQueued(this.getQueued());
        other.setQueuedCount(this.getQueuedCount());
        other.setQueuedSize(this.getQueuedSize());
        other.setPercentUseBytes(this.getPercentUseBytes());
        other.setPercentUseCount(this.getPercentUseCount());
        return other;
    }
}

