/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.resource;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.components.resource.FileResourceReference;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.ResourceType;

public class StandardResourceReferences
implements ResourceReferences {
    public List<ResourceReference> resourceReferences;

    public StandardResourceReferences(List<ResourceReference> resourceReferences) {
        this.resourceReferences = Objects.requireNonNull(resourceReferences);
    }

    @Override
    public List<ResourceReference> asList() {
        return Collections.unmodifiableList(this.resourceReferences);
    }

    @Override
    public List<String> asLocations() {
        ArrayList<String> locations = new ArrayList<String>(this.resourceReferences.size());
        this.resourceReferences.forEach(ref -> locations.add(ref.getLocation()));
        return locations;
    }

    @Override
    public List<URL> asURLs() {
        ArrayList<URL> locations = new ArrayList<URL>(this.resourceReferences.size());
        this.resourceReferences.forEach(ref -> locations.add(ref.asURL()));
        return locations;
    }

    @Override
    public int getCount() {
        return this.resourceReferences.size();
    }

    @Override
    public ResourceReferences flatten() {
        if (this.resourceReferences.isEmpty()) {
            return this;
        }
        ArrayList<ResourceReference> flattened = new ArrayList<ResourceReference>();
        this.resourceReferences.forEach(reference -> {
            if (reference.getResourceType() == ResourceType.DIRECTORY) {
                this.addChildren(reference.asFile(), flattened);
            } else {
                flattened.add((ResourceReference)reference);
            }
        });
        return new StandardResourceReferences(flattened);
    }

    private void addChildren(File file, List<ResourceReference> flattened) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (!child.isFile()) continue;
                    flattened.add(new FileResourceReference(child));
                }
            }
        } else {
            flattened.add(new FileResourceReference(file));
        }
    }

    @Override
    public ResourceReferences flattenRecursively() {
        if (this.resourceReferences.isEmpty()) {
            return this;
        }
        ArrayList<ResourceReference> flattened = new ArrayList<ResourceReference>();
        this.resourceReferences.forEach(reference -> {
            if (reference.getResourceType() == ResourceType.DIRECTORY) {
                this.recurse(reference.asFile(), flattened);
            } else {
                flattened.add((ResourceReference)reference);
            }
        });
        return new StandardResourceReferences(flattened);
    }

    private void recurse(File file, List<ResourceReference> flattened) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.recurse(child, flattened);
                }
            }
        } else {
            flattened.add(new FileResourceReference(file));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardResourceReferences that = (StandardResourceReferences)o;
        return Objects.equals(this.resourceReferences, that.resourceReferences);
    }

    public int hashCode() {
        return Objects.hash(this.resourceReferences);
    }

    public String toString() {
        return "StandardResourceReferences[resources=" + this.resourceReferences + "]";
    }
}

