/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.resource;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.resource.FileResourceReference;
import org.apache.nifi.components.resource.ResourceDefinition;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.components.resource.StandardResourceReferences;
import org.apache.nifi.components.resource.URLResourceReference;
import org.apache.nifi.components.resource.Utf8TextResource;

public class StandardResourceReferenceFactory
implements ResourceReferenceFactory {
    @Override
    public ResourceReferences createResourceReferences(String value, ResourceDefinition resourceDefinition) {
        if (value == null) {
            return new StandardResourceReferences(Collections.emptyList());
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (resourceDefinition == null) {
            return null;
        }
        List<String> locations = this.parseResourceLocations(value);
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(locations.size());
        locations.forEach(location -> references.add(this.createResourceReference((String)location, resourceDefinition)));
        return new StandardResourceReferences(references);
    }

    @Override
    public ResourceReference createResourceReference(String value, ResourceDefinition resourceDefinition) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (resourceDefinition == null) {
            return null;
        }
        Set<ResourceType> allowedResourceTypes = resourceDefinition.getResourceTypes();
        if (allowedResourceTypes.contains((Object)ResourceType.URL)) {
            try {
                if (trimmed.startsWith("http://") || trimmed.startsWith("https://")) {
                    return new URLResourceReference(new URL(trimmed));
                }
                if (trimmed.startsWith("file:")) {
                    URL url = new URL(trimmed);
                    String filename = url.getFile();
                    File file = new File(filename);
                    return new FileResourceReference(file);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL: " + trimmed);
            }
        }
        boolean fileAllowed = allowedResourceTypes.contains((Object)ResourceType.FILE) || allowedResourceTypes.contains((Object)ResourceType.DIRECTORY);
        boolean textAllowed = allowedResourceTypes.contains((Object)ResourceType.TEXT);
        if (fileAllowed && textAllowed) {
            File file = new File(trimmed);
            if (file.isAbsolute() || file.exists()) {
                return new FileResourceReference(file);
            }
            if (trimmed.startsWith("./") || trimmed.startsWith(".\\")) {
                return new FileResourceReference(file);
            }
            return new Utf8TextResource(value);
        }
        if (fileAllowed) {
            File file = new File(trimmed);
            return new FileResourceReference(file);
        }
        if (textAllowed) {
            return new Utf8TextResource(value);
        }
        return null;
    }

    private List<String> parseResourceLocations(String rawValue) {
        String[] splits;
        ArrayList<String> resourceLocations = new ArrayList<String>();
        for (String split : splits = rawValue.split(",")) {
            String trimmed = split.trim();
            if (trimmed.isEmpty()) continue;
            resourceLocations.add(trimmed);
        }
        return resourceLocations;
    }
}

