/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.util.Collections;
import java.util.Iterator;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.util.CloseableIterator;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.apache.maven.surefire.booter.CommandReader;

final class LazyTestsToRun
extends TestsToRun {
    private final MasterProcessChannelEncoder eventChannel;
    private final CommandReader commandReader;

    LazyTestsToRun(MasterProcessChannelEncoder eventChannel, CommandReader commandReader) {
        super(Collections.emptySet());
        this.eventChannel = eventChannel;
        this.commandReader = commandReader;
    }

    public Iterator<Class<?>> iterated() {
        return this.newWeakIterator();
    }

    public Iterator<Class<?>> iterator() {
        return new BlockingIterator();
    }

    public String toString() {
        return "LazyTestsToRun";
    }

    public boolean allowEagerReading() {
        return false;
    }

    private static Class<?> findClass(String clazz) {
        return ReflectionUtils.loadClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)clazz);
    }

    private Iterator<Class<?>> newWeakIterator() {
        final Iterator<String> it = this.commandReader.iterated();
        return new CloseableIterator<Class<?>>(){

            protected boolean isClosed() {
                return LazyTestsToRun.this.isFinished();
            }

            protected boolean doHasNext() {
                return it.hasNext();
            }

            protected Class<?> doNext() {
                return LazyTestsToRun.findClass((String)it.next());
            }

            protected void doRemove() {
            }

            public void remove() {
                throw new UnsupportedOperationException("unsupported remove");
            }
        };
    }

    private final class BlockingIterator
    implements Iterator<Class<?>> {
        private final Iterator<String> it;

        private BlockingIterator() {
            this.it = LazyTestsToRun.this.commandReader.getIterableClasses(LazyTestsToRun.this.eventChannel).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Class<?> next() {
            return LazyTestsToRun.findClass(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

