/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.AuthHelper;
import kafka.server.EnvelopeUtils$;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001B\u00193\u0001]B\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003T\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011M\u0004!Q1A\u0005\u0002QD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\t{\u0002\u0011)\u0019!C\u0001}\"I\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003G\u0001!Q1A\u0005\u0002\u0005\u0015\u0002BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\t\u0015\u0005%\u0003A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002L\u0001\u0011)\u0019!C\u0001\u0003\u001bB!\"!\u0016\u0001\u0005\u0003\u0005\u000b\u0011BA(\u0011)\t9\u0006\u0001BC\u0002\u0013\u0005\u0011\u0011\f\u0005\u000b\u0003C\u0002!\u0011!Q\u0001\n\u0005m\u0003BCA2\u0001\t\u0015\r\u0011\"\u0001\u0002f!Q\u0011\u0011\u0011\u0001\u0003\u0002\u0003\u0006I!a\u001a\t\u0015\u0005\r\u0005A!b\u0001\n\u0003\t)\t\u0003\u0006\u0002\u000e\u0002\u0011\t\u0011)A\u0005\u0003\u000fCq!a$\u0001\t\u0003\t\t\nC\u0005\u0002,\u0002\u0011\r\u0011\"\u0001\u0002.\"A\u0011Q\u0017\u0001!\u0002\u0013\ty\u000bC\u0005\u00028\u0002\u0011\r\u0011\"\u0001\u0002:\"A\u0011\u0011\u0019\u0001!\u0002\u0013\tY\fC\u0004\u0002D\u0002!\t%!2\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0003c\u0004A\u0011BAz\u0011\u001d\t9\u0010\u0001C\u0001\u0003sDq!!@\u0001\t\u0003\ty\u0010C\u0004\u0003\u0004\u0001!\tA!\u0002\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!1\u0010\u0001\u0005\u0002\tu\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0011\u001d\u0011i\t\u0001C\u0005\u0005\u001fCqAa%\u0001\t\u0013\u0011)\nC\u0004\u0003\u001a\u0002!\tAa'\t\u000f\t}\u0005\u0001\"\u0001\u0003\"\"9!Q\u0015\u0001\u0005\u0002\t\u001d\u0006b\u0002BV\u0001\u0011\u0005!Q\u0016\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u001d\u0011)\u000e\u0001C\u0001\u0005/DqAa7\u0001\t\u0003\u0011iN\u0001\bD_:$(o\u001c7mKJ\f\u0005/[:\u000b\u0005M\"\u0014AB:feZ,'OC\u00016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u001d?\u0005B\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\u0004\"a\u0010!\u000e\u0003IJ!!\u0011\u001a\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'\u000f\u0005\u0002D\r6\tAI\u0003\u0002Fi\u0005)Q\u000f^5mg&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bR\nqA\\3uo>\u00148.\u0003\u0002P\u0019\nq!+Z9vKN$8\t[1o]\u0016d\u0017a\u0004:fcV,7\u000f^\"iC:tW\r\u001c\u0011\u0002\u0015\u0005,H\u000f[8sSj,'/F\u0001T!\rIDKV\u0005\u0003+j\u0012aa\u00149uS>t\u0007CA,`\u001b\u0005A&BA)Z\u0015\t\u0019$L\u0003\u000267*\u0011A,X\u0001\u0007CB\f7\r[3\u000b\u0003y\u000b1a\u001c:h\u0013\t\u0001\u0007L\u0001\u0006BkRDwN]5{KJ\f1\"Y;uQ>\u0014\u0018N_3sA\u00051\u0011/^8uCN,\u0012\u0001\u001a\t\u0003K>t!AZ7\u000f\u0005\u001ddgB\u00015l\u001b\u0005I'B\u000167\u0003\u0019a$o\\8u}%\tQ'\u0003\u00024i%\u0011aNM\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0003aF\u0014Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(B\u000183\u0003\u001d\tXo\u001c;bg\u0002\nA\u0001^5nKV\tQ\u000f\u0005\u0002wu6\tqO\u0003\u0002Fq*\u0011\u0011PW\u0001\u0007G>lWn\u001c8\n\u0005m<(\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0011c];qa>\u0014H/\u001a3GK\u0006$XO]3t+\u0005y\b\u0003CA\u0001\u0003\u0013\ty!!\u0006\u000f\t\u0005\r\u0011Q\u0001\t\u0003QjJ1!a\u0002;\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u000fQ\u0004\u0003BA\u0001\u0003#IA!a\u0005\u0002\u000e\t11\u000b\u001e:j]\u001e\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037Q\u0016\u0001C7fi\u0006$\u0017\r^1\n\t\u0005}\u0011\u0011\u0004\u0002\r-\u0016\u00148/[8o%\u0006tw-Z\u0001\u0013gV\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001c\b%\u0001\u0006d_:$(o\u001c7mKJ,\"!a\n\u0011\t\u0005%\u0012QF\u0007\u0003\u0003WQ1!a\t[\u0013\u0011\ty#a\u000b\u0003\u0015\r{g\u000e\u001e:pY2,'/A\u0006d_:$(o\u001c7mKJ\u0004\u0013a\u0003:bMRl\u0015M\\1hKJ,\"!a\u000e\u0011\r\u0005e\u0012qHA\"\u001b\t\tYDC\u0002\u0002>Q\nAA]1gi&!\u0011\u0011IA\u001e\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\t\u0005]\u0011QI\u0005\u0005\u0003\u000f\nIB\u0001\u000bBa&lUm]:bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\re\u00064G/T1oC\u001e,'\u000fI\u0001\u0007G>tg-[4\u0016\u0005\u0005=\u0003cA \u0002R%\u0019\u00111\u000b\u001a\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u00039iW\r^1Qe>\u0004XM\u001d;jKN,\"!a\u0017\u0011\u0007}\ni&C\u0002\u0002`I\u0012a\"T3uCB\u0013x\u000e]3si&,7/A\bnKR\f\u0007K]8qKJ$\u0018.Z:!\u0003=\u0019wN\u001c;s_2dWM\u001d(pI\u0016\u001cXCAA4!\u0019\tI'a\u001d\u0002z9!\u00111NA8\u001d\rA\u0017QN\u0005\u0002w%\u0019\u0011\u0011\u000f\u001e\u0002\u000fA\f7m[1hK&!\u0011QOA<\u0005\r\u0019V-\u001d\u0006\u0004\u0003cR\u0004\u0003BA>\u0003{j\u0011\u0001_\u0005\u0004\u0003\u007fB(\u0001\u0002(pI\u0016\f\u0001cY8oiJ|G\u000e\\3s\u001d>$Wm\u001d\u0011\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'/\u0006\u0002\u0002\bB\u0019q(!#\n\u0007\u0005-%GA\tBa&4VM]:j_:l\u0015M\\1hKJ\f!#\u00199j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3sA\u00051A(\u001b8jiz\"\u0002$a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0016qUAU!\ty\u0004\u0001C\u0003I/\u0001\u0007!\nC\u0003R/\u0001\u00071\u000bC\u0003c/\u0001\u0007A\rC\u0003t/\u0001\u0007Q\u000fC\u0003~/\u0001\u0007q\u0010C\u0004\u0002$]\u0001\r!a\n\t\u000f\u0005Mr\u00031\u0001\u00028!9\u00111J\fA\u0002\u0005=\u0003bBA,/\u0001\u0007\u00111\f\u0005\b\u0003G:\u0002\u0019AA4\u0011\u001d\t\u0019i\u0006a\u0001\u0003\u000f\u000b!\"Y;uQ\"+G\u000e]3s+\t\ty\u000bE\u0002@\u0003cK1!a-3\u0005)\tU\u000f\u001e5IK2\u0004XM]\u0001\fCV$\b\u000eS3ma\u0016\u0014\b%A\u0007sKF,Xm\u001d;IK2\u0004XM]\u000b\u0003\u0003w\u00032aPA_\u0013\r\tyL\r\u0002\u0015%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0011\u0016d\u0007/\u001a:\u0002\u001dI,\u0017/^3ti\"+G\u000e]3sA\u00051\u0001.\u00198eY\u0016$B!a2\u0002NB\u0019\u0011(!3\n\u0007\u0005-'H\u0001\u0003V]&$\bbBAh9\u0001\u0007\u0011\u0011[\u0001\be\u0016\fX/Z:u!\u0011\t\u0019.!7\u000f\u0007-\u000b).C\u0002\u0002X2\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u0002\\\u0006u'a\u0002*fcV,7\u000f\u001e\u0006\u0004\u0003/d\u0015!\u00065b]\u0012dW-\u00128wK2|\u0007/\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003\u000f\f\u0019\u000fC\u0004\u0002Pv\u0001\r!!5\u00025!\fg\u000e\u001a7f'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;\u0015\t\u0005\u001d\u0017\u0011\u001e\u0005\b\u0003\u001ft\u0002\u0019AAi\u0003uA\u0017M\u001c3mKN\u000b7\u000f\\!vi\",g\u000e^5dCR,'+Z9vKN$H\u0003BAd\u0003_Dq!a4 \u0001\u0004\t\t.A\u0006iC:$G.\u001a$fi\u000eDG\u0003BAd\u0003kDq!a4!\u0001\u0004\t\t.A\u000biC:$G.Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0015\t\u0005\u001d\u00171 \u0005\b\u0003\u001f\f\u0003\u0019AAi\u0003IA\u0017M\u001c3mK\u0012+G.\u001a;f)>\u0004\u0018nY:\u0015\t\u0005\u001d'\u0011\u0001\u0005\b\u0003\u001f\u0014\u0003\u0019AAi\u00031!W\r\\3uKR{\u0007/[2t)1\u00119A!\u0010\u0003H\tE#1\fB9!\u0019\u0011IAa\u0005\u0003\u00185\u0011!1\u0002\u0006\u0005\u0005\u001b\u0011y!\u0001\u0003vi&d'B\u0001B\t\u0003\u0011Q\u0017M^1\n\t\tU!1\u0002\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0003\u001a\t]b\u0002\u0002B\u000e\u0005cqAA!\b\u0003.9!!q\u0004B\u0016\u001d\u0011\u0011\tC!\u000b\u000f\t\t\r\"q\u0005\b\u0004Q\n\u0015\u0012\"\u00010\n\u0005qk\u0016BA\u001b\\\u0013\tI(,C\u0002\u00030a\fq!\\3tg\u0006<W-\u0003\u0003\u00034\tU\u0012\u0001\u0007#fY\u0016$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\rR1uC*\u0019!q\u0006=\n\t\te\"1\b\u0002\u0015\t\u0016dW\r^1cY\u0016$v\u000e]5d%\u0016\u001cX\u000f\u001c;\u000b\t\tM\"Q\u0007\u0005\b\u0003\u001f\u001c\u0003\u0019\u0001B !\u0011\u0011\tEa\u0011\u000e\u0005\tU\u0012\u0002\u0002B#\u0005k\u0011q\u0003R3mKR,Gk\u001c9jGN\u0014V-];fgR$\u0015\r^1\t\u000f\t%3\u00051\u0001\u0003L\u0005Q\u0011\r]5WKJ\u001c\u0018n\u001c8\u0011\u0007e\u0012i%C\u0002\u0003Pi\u00121!\u00138u\u0011\u001d\u0011\u0019f\ta\u0001\u0005+\na\u0002[1t\u00072,8\u000f^3s\u0003V$\b\u000eE\u0002:\u0005/J1A!\u0017;\u0005\u001d\u0011un\u001c7fC:DqA!\u0018$\u0001\u0004\u0011y&\u0001\u000bhKR$Um]2sS\n\f'\r\\3U_BL7m\u001d\t\bs\t\u0005$Q\rB6\u0013\r\u0011\u0019G\u000f\u0002\n\rVt7\r^5p]F\u0002b!!\u001b\u0003h\u0005=\u0011\u0002\u0002B5\u0003o\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0007\u0003\u0003\u0011i'a\u0004\n\t\t=\u0014Q\u0002\u0002\u0004'\u0016$\bb\u0002B:G\u0001\u0007!qL\u0001\u0013O\u0016$H)\u001a7fi\u0006\u0014G.\u001a+pa&\u001c7/\u0001\niC:$G.Z\"sK\u0006$X\rV8qS\u000e\u001cH\u0003BAd\u0005sBq!a4%\u0001\u0004\t\t.\u0001\riC:$G.Z!qSZ+'o]5p]N\u0014V-];fgR$B!a2\u0003\u0000!9\u0011qZ\u0013A\u0002\u0005E\u0017A\u00035b]\u0012dWMV8uKR!\u0011q\u0019BC\u0011\u001d\tyM\na\u0001\u0003#\fa\u0003[1oI2,')Z4j]F+xN];n\u000bB|7\r\u001b\u000b\u0005\u0003\u000f\u0014Y\tC\u0004\u0002P\u001e\u0002\r!!5\u0002)!\fg\u000e\u001a7f\u000b:$\u0017+^8sk6,\u0005o\\2i)\u0011\t9M!%\t\u000f\u0005=\u0007\u00061\u0001\u0002R\u0006!\u0002.\u00198eY\u0016$Um]2sS\n,\u0017+^8sk6$B!a2\u0003\u0018\"9\u0011qZ\u0015A\u0002\u0005E\u0017!\u00065b]\u0012dW-\u00117uKJL5O\u001d*fcV,7\u000f\u001e\u000b\u0005\u0003\u000f\u0014i\nC\u0004\u0002P*\u0002\r!!5\u00029!\fg\u000e\u001a7f\u0005J|7.\u001a:IK\u0006\u0014HOQ3biJ+\u0017/^3tiR!\u0011q\u0019BR\u0011\u001d\tym\u000ba\u0001\u0003#\fa\u0003[1oI2,WK\u001c:fO&\u001cH/\u001a:Ce>\\WM\u001d\u000b\u0005\u0003\u000f\u0014I\u000bC\u0004\u0002P2\u0002\r!!5\u00021!\fg\u000e\u001a7f\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g\u000e\u0006\u0003\u0002H\n=\u0006bBAh[\u0001\u0007\u0011\u0011[\u0001\u0012Q\u0006tG\r\\3SC\u001a$(+Z9vKN$HCBAd\u0005k\u00139\fC\u0004\u0002P:\u0002\r!!5\t\u000f\tef\u00061\u0001\u0003<\u0006i!-^5mIJ+7\u000f]8og\u0016\u0004r!\u000fB1\u0005{\u0013I\r\u0005\u0003\u0003@\n\u0015WB\u0001Ba\u0015\r\u0011\u0019\r_\u0001\taJ|Go\\2pY&!!q\u0019Ba\u0005)\t\u0005/['fgN\fw-\u001a\t\u0005\u0005\u0017\u0014\t.\u0004\u0002\u0003N*\u0019!q\u001a=\u0002\u0011I,\u0017/^3tiNLAAa5\u0003N\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0018Q\u0006tG\r\\3BYR,'o\u00117jK:$\u0018+^8uCN$B!a2\u0003Z\"9\u0011qZ\u0018A\u0002\u0005E\u0017!\b5b]\u0012dW-\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:\u0015\t\u0005\u001d'q\u001c\u0005\b\u0003\u001f\u0004\u0004\u0019AAi\u0001")
public class ControllerApis
implements ApiRequestHandler,
Logging {
    private final RequestChannel requestChannel;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private final scala.collection.immutable.Map<String, VersionRange> supportedFeatures;
    private final Controller controller;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final KafkaConfig config;
    private final MetaProperties metaProperties;
    private final Seq<Node> controllerNodes;
    private final ApiVersionManager apiVersionManager;
    private final AuthHelper authHelper;
    private final RequestHandlerHelper requestHelper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public Time time() {
        return this.time;
    }

    public scala.collection.immutable.Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Controller controller() {
        return this.controller;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public Seq<Node> controllerNodes() {
        return this.controllerNodes;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    @Override
    public void handle(RequestChannel.Request request) {
        block22: {
            try {
                ApiKeys apiKeys = request.header().apiKey();
                if (ApiKeys.FETCH.equals(apiKeys)) {
                    this.handleFetch(request);
                    break block22;
                }
                if (ApiKeys.METADATA.equals(apiKeys)) {
                    this.handleMetadataRequest(request);
                    break block22;
                }
                if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                    this.handleCreateTopics(request);
                    break block22;
                }
                if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                    this.handleDeleteTopics(request);
                    break block22;
                }
                if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                    this.handleApiVersionsRequest(request);
                    break block22;
                }
                if (ApiKeys.VOTE.equals(apiKeys)) {
                    this.handleVote(request);
                    break block22;
                }
                if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                    this.handleBeginQuorumEpoch(request);
                    break block22;
                }
                if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                    this.handleEndQuorumEpoch(request);
                    break block22;
                }
                if (ApiKeys.DESCRIBE_QUORUM.equals(apiKeys)) {
                    this.handleDescribeQuorum(request);
                    break block22;
                }
                if (ApiKeys.ALTER_ISR.equals(apiKeys)) {
                    this.handleAlterIsrRequest(request);
                    break block22;
                }
                if (ApiKeys.BROKER_REGISTRATION.equals(apiKeys)) {
                    this.handleBrokerRegistration(request);
                    break block22;
                }
                if (ApiKeys.BROKER_HEARTBEAT.equals(apiKeys)) {
                    this.handleBrokerHeartBeatRequest(request);
                    break block22;
                }
                if (ApiKeys.UNREGISTER_BROKER.equals(apiKeys)) {
                    this.handleUnregisterBroker(request);
                    break block22;
                }
                if (ApiKeys.ALTER_CLIENT_QUOTAS.equals(apiKeys)) {
                    this.handleAlterClientQuotas(request);
                    break block22;
                }
                if (ApiKeys.INCREMENTAL_ALTER_CONFIGS.equals(apiKeys)) {
                    this.handleIncrementalAlterConfigs(request);
                    break block22;
                }
                if (ApiKeys.ENVELOPE.equals(apiKeys)) {
                    this.handleEnvelopeRequest(request);
                    break block22;
                }
                if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                    this.handleSaslHandshakeRequest(request);
                    break block22;
                }
                if (ApiKeys.SASL_AUTHENTICATE.equals(apiKeys)) {
                    this.handleSaslAuthenticateRequest(request);
                    break block22;
                }
                throw new ApiException(new StringBuilder(19).append("Unsupported ApiKey ").append(request.context().header.apiKey()).toString());
            }
            catch (FatalExitError fatalExitError) {
                throw fatalExitError;
            }
            catch (ExecutionException e) {
                this.requestHelper().handleError(request, e.getCause());
                return;
            }
            catch (Throwable e) {
                this.requestHelper().handleError(request, e);
            }
        }
    }

    public void handleEnvelopeRequest(RequestChannel.Request request2) {
        if (!this.authHelper().authorize(request2.context(), AclOperation.CLUSTER_ACTION, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            this.requestHelper().sendErrorResponseMaybeThrottle(request2, (Throwable)new ClusterAuthorizationException(new StringBuilder(61).append("Principal ").append(request2.context().principal).append(" does not have required CLUSTER_ACTION for envelope").toString()));
            return;
        }
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(request2, this.requestChannel().metrics(), (Function1<RequestChannel.Request, BoxedUnit>)(Function1 & Serializable & scala.Serializable)request -> {
            this.handle(request);
            return BoxedUnit.UNIT;
        });
    }

    public void handleSaslHandshakeRequest(RequestChannel.Request request) {
        SaslHandshakeResponseData responseData = new SaslHandshakeResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code());
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)x$1 -> ControllerApis.$anonfun$handleSaslHandshakeRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public void handleSaslAuthenticateRequest(RequestChannel.Request request) {
        SaslAuthenticateResponseData responseData = new SaslAuthenticateResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code()).setErrorMessage("SaslAuthenticate request received after successful authentication");
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)x$2 -> ControllerApis.$anonfun$handleSaslAuthenticateRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    private void handleFetch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleMetadataRequest(RequestChannel.Request request) {
        MetadataRequest metadataRequest = (MetadataRequest)request.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> this.createResponseCallback$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs), metadataRequest, request));
    }

    public void handleDeleteTopics(RequestChannel.Request request) {
        List<DeleteTopicsResponseData.DeletableTopicResult> responses = this.deleteTopics(((DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).data(), request.context().apiVersion(), this.authHelper().authorize(request.context(), AclOperation.DELETE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable & scala.Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable & scala.Serializable)n -> n), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable & scala.Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DELETE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable & scala.Serializable)n -> n));
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleDeleteTopics$5(responses, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    /*
     * WARNING - void declaration
     */
    public List<DeleteTopicsResponseData.DeletableTopicResult> deleteTopics(DeleteTopicsRequestData request, int apiVersion, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDeletableTopics) {
        void var16_16;
        void var15_15;
        if (!Predef$.MODULE$.Boolean2boolean(this.config().deleteTopicEnable())) {
            if (apiVersion < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
        ArrayList<DeleteTopicsResponseData.DeletableTopicResult> responses = new ArrayList<DeleteTopicsResponseData.DeletableTopicResult>();
        HashSet providedNames = new HashSet();
        HashSet duplicateProvidedNames = new HashSet();
        HashSet providedIds = new HashSet();
        HashSet duplicateProvidedIds = new HashSet();
        request.topicNames().forEach(name -> ControllerApis.addProvidedName$1(name, duplicateProvidedNames, providedNames));
        request.topics().forEach(topic -> {
            if (topic.name() == null) {
                if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                    ControllerApis.appendResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                    return;
                }
                if (duplicateProvidedIds.contains(topic.topicId()) || !providedIds.add(topic.topicId())) {
                    duplicateProvidedIds.add(topic.topicId());
                    providedIds.remove(topic.topicId());
                    return;
                }
            } else {
                if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                    ControllerApis.addProvidedName$1(topic.name(), duplicateProvidedNames, providedNames);
                    return;
                }
                ControllerApis.appendResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
            }
        });
        duplicateProvidedNames.forEach(name -> ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses));
        duplicateProvidedIds.forEach(id -> ControllerApis.appendResponse$1(null, id, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses));
        HashSet toAuthenticate = new HashSet();
        toAuthenticate.addAll(providedNames);
        HashMap idToName = new HashMap();
        ((Map)this.controller().findTopicNames(providedIds).get()).forEach((id, nameOrError) -> {
            if (nameOrError.isError()) {
                ControllerApis.appendResponse$1(null, id, nameOrError.error(), responses);
                return;
            }
            toAuthenticate.add(nameOrError.result());
            idToName.put(id, nameOrError.result());
        });
        Set topicsToAuthenticate = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(toAuthenticate).asScala();
        Tuple2 tuple2 = hasClusterAuth ? new Tuple2((Object)topicsToAuthenticate.toSet(), (Object)topicsToAuthenticate.toSet()) : new Tuple2(getDescribableTopics.apply((Object)topicsToAuthenticate), getDeletableTopics.apply((Object)topicsToAuthenticate));
        scala.collection.immutable.Set describeable = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set deletable = (scala.collection.immutable.Set)tuple2._2();
        void describeable2 = var15_15;
        void deletable2 = var16_16;
        Iterator iterator = idToName.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Uuid id2 = (Uuid)entry.getKey();
            String name2 = (String)entry.getValue();
            if (deletable2.contains((Object)name2)) continue;
            if (describeable2.contains((Object)name2)) {
                ControllerApis.appendResponse$1(name2, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
            } else {
                ControllerApis.appendResponse$1(null, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
            }
            iterator.remove();
        }
        ((Map)this.controller().findTopicIds(providedNames).get()).forEach((arg_0, arg_1) -> ControllerApis.$anonfun$deleteTopics$6((scala.collection.immutable.Set)describeable2, (scala.collection.immutable.Set)deletable2, duplicateProvidedIds, idToName, responses, arg_0, arg_1));
        ((Map)this.controller().deleteTopics(idToName.keySet()).get()).forEach((id, error) -> ControllerApis.appendResponse$1((String)idToName.get(id), id, error, responses));
        Collections.shuffle(responses);
        return responses;
    }

    /*
     * WARNING - void declaration
     */
    public void handleCreateTopics(RequestChannel.Request request) {
        void var7_8;
        void var6_7;
        Nil$ nil$;
        CreateTopicsRequestData createTopicsRequestData;
        CreateTopicsRequest createTopicRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        if (this.authHelper().authorize(request.context(), AclOperation.CREATE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            createTopicsRequestData = createTopicRequest.data();
            nil$ = Nil$.MODULE$;
        } else {
            CreateTopicsRequestData duplicate = createTopicRequest.data().duplicate();
            CreateTopicsRequestData.CreatableTopicCollection authorizedTopics = new CreateTopicsRequestData.CreatableTopicCollection();
            Buffer unauthorizedTopics = (Buffer)Buffer$.MODULE$.empty();
            createTopicRequest.data().topics().forEach(topicData -> {
                if (this.authHelper().authorize(request.context(), AclOperation.CREATE, ResourceType.TOPIC, topicData.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                    authorizedTopics.add((ImplicitLinkedHashCollection.Element)topicData);
                    return;
                }
                unauthorizedTopics.$plus$eq((Object)topicData.name());
            });
            createTopicsRequestData = duplicate.setTopics(authorizedTopics);
            nil$ = unauthorizedTopics;
        }
        Nil$ nil$2 = nil$;
        CreateTopicsRequestData authorizedCreateRequest = createTopicsRequestData;
        Seq unauthorizedTopics = (Seq)nil$2;
        if (var6_7.topics().isEmpty()) {
            this.sendResponse$1(new CreateTopicsResponseData(), (Seq)var7_8, request);
            return;
        }
        this.controller().createTopics((CreateTopicsRequestData)var6_7).whenComplete((arg_0, arg_1) -> ControllerApis.$anonfun$handleCreateTopics$4(this, createTopicRequest, (Seq)var7_8, request, arg_0, arg_1));
    }

    public void handleApiVersionsRequest(RequestChannel.Request request) {
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> this.createResponseCallback$2(BoxesRunTime.unboxToInt((Object)requestThrottleMs), request));
    }

    private void handleVote(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    private void handleDescribeQuorum(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new DescribeQuorumResponse((DescribeQuorumResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleAlterIsrRequest(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        AlterIsrRequest alterIsrRequest = (AlterIsrRequest)request.body(ClassTag$.MODULE$.apply(AlterIsrRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.controller().alterIsr(alterIsrRequest.data()).whenComplete((result, exception) -> {
            AlterIsrResponse response = exception != null ? alterIsrRequest.getErrorResponse(exception) : new AlterIsrResponse(result);
            this.requestHelper().sendResponseExemptThrottle(request, (AbstractResponse)response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleBrokerHeartBeatRequest(RequestChannel.Request request) {
        BrokerHeartbeatRequest heartbeatRequest = (BrokerHeartbeatRequest)request.body(ClassTag$.MODULE$.apply(BrokerHeartbeatRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().processBrokerHeartbeat(heartbeatRequest.data()).handle((T reply, U e) -> {
            ControllerApis.$anonfun$handleBrokerHeartBeatRequest$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    public void handleUnregisterBroker(RequestChannel.Request request) {
        UnregisterBrokerRequest decommissionRequest = (UnregisterBrokerRequest)request.body(ClassTag$.MODULE$.apply(UnregisterBrokerRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        this.controller().unregisterBroker(decommissionRequest.data().brokerId()).handle((T x$5, U e) -> {
            ControllerApis.$anonfun$handleUnregisterBroker$1(this, request, x$5, e);
            return BoxedUnit.UNIT;
        });
    }

    public void handleBrokerRegistration(RequestChannel.Request request) {
        BrokerRegistrationRequest registrationRequest = (BrokerRegistrationRequest)request.body(ClassTag$.MODULE$.apply(BrokerRegistrationRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        this.controller().registerBroker(registrationRequest.data()).handle((T reply, U e) -> {
            ControllerApis.$anonfun$handleBrokerRegistration$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    private void handleRaftRequest(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager().handleRequest(request.header(), requestBody.data(), this.time().milliseconds()).whenComplete((responseData, exception) -> {
            AbstractResponse response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, response, this.requestHelper().sendResponseExemptThrottle$default$3());
        });
    }

    public void handleAlterClientQuotas(RequestChannel.Request request) {
        AlterClientQuotasRequest quotaRequest = (AlterClientQuotasRequest)request.body(ClassTag$.MODULE$.apply(AlterClientQuotasRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorize(request.context(), AclOperation.ALTER_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
        this.controller().alterClientQuotas((Collection)quotaRequest.entries(), quotaRequest.validateOnly()).whenComplete((results, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterClientQuotas$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public void handleIncrementalAlterConfigs(RequestChannel.Request request) {
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorize(request.context(), AclOperation.ALTER_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7());
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            HashMap altersByName = new HashMap();
            resource.configs().forEach(config -> altersByName.put(config.name(), new AbstractMap.SimpleEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.forId((byte)config.configOperation()), config.value())));
            configChanges.put(configResource, altersByName);
        });
        this.controller().incrementalAlterConfigs(configChanges, alterConfigsRequest.data().validateOnly()).whenComplete((results, exception) -> {
            if (exception != null) {
                this.requestHelper().handleError(request, (Throwable)exception);
                return;
            }
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleIncrementalAlterConfigs$4(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        });
    }

    public static final /* synthetic */ SaslHandshakeResponse $anonfun$handleSaslHandshakeRequest$1(SaslHandshakeResponseData responseData$1, int x$1) {
        return new SaslHandshakeResponse(responseData$1);
    }

    public static final /* synthetic */ SaslAuthenticateResponse $anonfun$handleSaslAuthenticateRequest$1(SaslAuthenticateResponseData responseData$2, int x$2) {
        return new SaslAuthenticateResponse(responseData$2);
    }

    public static final /* synthetic */ boolean $anonfun$handleMetadataRequest$1(MetadataResponseData metadataResponseData$1, Node node) {
        return metadataResponseData$1.brokers().add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack()));
    }

    private final MetadataResponse createResponseCallback$1(int requestThrottleMs, MetadataRequest metadataRequest$1, RequestChannel.Request request$1) {
        MetadataResponseData metadataResponseData = new MetadataResponseData();
        metadataResponseData.setThrottleTimeMs(requestThrottleMs);
        this.controllerNodes().foreach((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)ControllerApis.$anonfun$handleMetadataRequest$1(metadataResponseData, node)));
        metadataResponseData.setClusterId(this.metaProperties().clusterId().toString());
        if (this.controller().isActive()) {
            metadataResponseData.setControllerId(this.config().nodeId());
        } else {
            metadataResponseData.setControllerId(-1);
        }
        int clusterAuthorizedOperations = metadataRequest$1.data().includeClusterAuthorizedOperations() ? (this.authHelper().authorize(request$1.context(), AclOperation.DESCRIBE, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()) ? this.authHelper().authorizedOperations(request$1, Resource.CLUSTER) : 0) : Integer.MIN_VALUE;
        metadataResponseData.setClusterAuthorizedOperations(clusterAuthorizedOperations);
        return new MetadataResponse(metadataResponseData, request$1.header().apiVersion());
    }

    public static final /* synthetic */ DeleteTopicsResponse $anonfun$handleDeleteTopics$5(List responses$1, int throttleTimeMs) {
        DeleteTopicsResponseData responseData = new DeleteTopicsResponseData().setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(responses$1.iterator())).setThrottleTimeMs(throttleTimeMs);
        return new DeleteTopicsResponse(responseData);
    }

    private static final void appendResponse$1(String name, Uuid id, ApiError error, ArrayList responses$2) {
        responses$2.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private static final void addProvidedName$1(String name, HashSet duplicateProvidedNames$1, HashSet providedNames$1) {
        if (duplicateProvidedNames$1.contains(name) || !providedNames$1.add(name)) {
            duplicateProvidedNames$1.add(name);
            providedNames$1.remove(name);
        }
    }

    public static final /* synthetic */ void $anonfun$deleteTopics$6(scala.collection.immutable.Set describeable$1, scala.collection.immutable.Set deletable$1, HashSet duplicateProvidedIds$1, HashMap idToName$1, ArrayList responses$2, String name, ResultOrError idOrError) {
        if (!describeable$1.contains((Object)name)) {
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$2);
            return;
        }
        if (idOrError.isError()) {
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, idOrError.error(), responses$2);
            return;
        }
        if (deletable$1.contains((Object)name)) {
            Uuid id = (Uuid)idOrError.result();
            if (duplicateProvidedIds$1.contains(id) || idToName$1.put(id, name) != null) {
                duplicateProvidedIds$1.add(id);
                idToName$1.remove(id);
                ControllerApis.appendResponse$1(name, id, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses$2);
                return;
            }
        } else {
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopics$2(CreateTopicsResponseData response$1, String topic) {
        CreateTopicsResponseData.CreatableTopicResult result = new CreateTopicsResponseData.CreatableTopicResult().setName(topic).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code());
        return response$1.topics().add((ImplicitLinkedHashCollection.Element)result);
    }

    public static final /* synthetic */ CreateTopicsResponse $anonfun$handleCreateTopics$3(CreateTopicsResponseData response$1, int throttleTimeMs) {
        response$1.setThrottleTimeMs(throttleTimeMs);
        return new CreateTopicsResponse(response$1);
    }

    private final void sendResponse$1(CreateTopicsResponseData response, Seq unauthorizedTopics$2, RequestChannel.Request request$3) {
        unauthorizedTopics$2.foreach((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)ControllerApis.$anonfun$handleCreateTopics$2(response, topic)));
        this.requestHelper().sendResponseMaybeThrottle(request$3, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleCreateTopics$3(response, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    public static final /* synthetic */ void $anonfun$handleCreateTopics$4(ControllerApis $this, CreateTopicsRequest createTopicRequest$1, Seq unauthorizedTopics$2, RequestChannel.Request request$3, CreateTopicsResponseData responseData, Throwable exception) {
        CreateTopicsResponseData response = exception != null ? ((CreateTopicsResponse)createTopicRequest$1.getErrorResponse(exception)).data() : responseData;
        $this.sendResponse$1(response, unauthorizedTopics$2, request$3);
    }

    private final ApiVersionsResponse createResponseCallback$2(int requestThrottleMs, RequestChannel.Request request$4) {
        ApiVersionsRequest apiVersionRequest = (ApiVersionsRequest)request$4.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        if (apiVersionRequest.hasUnsupportedRequestVersion()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.UNSUPPORTED_VERSION.exception());
        }
        if (!apiVersionRequest.isValid()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.INVALID_REQUEST.exception());
        }
        return this.apiVersionManager().apiVersionResponse(requestThrottleMs);
    }

    private static final BrokerHeartbeatResponse createResponseCallback$3(int requestThrottleMs, BrokerHeartbeatReply reply, Throwable e) {
        if (e != null) {
            return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setIsCaughtUp(reply.isCaughtUp()).setIsFenced(reply.isFenced()).setShouldShutDown(reply.shouldShutDown()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerHeartBeatRequest$1(ControllerApis $this, RequestChannel.Request request$6, BrokerHeartbeatReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$6, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$3(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    private static final UnregisterBrokerResponse createResponseCallback$4(int requestThrottleMs, Throwable e) {
        if (e != null) {
            return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUnregisterBroker$1(ControllerApis $this, RequestChannel.Request request$7, Void x$5, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$7, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$4(BoxesRunTime.unboxToInt((Object)requestThrottleMs), e));
    }

    private static final BrokerRegistrationResponse createResponseCallback$5(int requestThrottleMs, BrokerRegistrationReply reply, Throwable e) {
        if (e != null) {
            return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setBrokerEpoch(reply.epoch()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerRegistration$1(ControllerApis $this, RequestChannel.Request request$8, BrokerRegistrationReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$8, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$5(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    public static final /* synthetic */ AlterClientQuotasResponse $anonfun$handleAlterClientQuotas$2(Map results$1, int requestThrottleMs) {
        return AlterClientQuotasResponse.fromQuotaEntities((Map)results$1, (int)requestThrottleMs);
    }

    public static final /* synthetic */ IncrementalAlterConfigsResponse $anonfun$handleIncrementalAlterConfigs$4(Map results$2, int requestThrottleMs) {
        return new IncrementalAlterConfigsResponse(requestThrottleMs, results$2);
    }

    public ControllerApis(RequestChannel requestChannel, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, scala.collection.immutable.Map<String, VersionRange> supportedFeatures, Controller controller, RaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, MetaProperties metaProperties, Seq<Node> controllerNodes, ApiVersionManager apiVersionManager) {
        this.requestChannel = requestChannel;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.time = time;
        this.supportedFeatures = supportedFeatures;
        this.controller = controller;
        this.raftManager = raftManager;
        this.config = config;
        this.metaProperties = metaProperties;
        this.controllerNodes = controllerNodes;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
        this.authHelper = new AuthHelper(authorizer);
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time, new StringBuilder(21).append("[ControllerApis id=").append(config.nodeId()).append("] ").toString());
    }
}

