/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import org.apache.kafka.controller.ControllerMetrics;

public final class QuorumControllerMetrics
implements ControllerMetrics {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = new MetricName("kafka.controller", "KafkaController", "ActiveControllerCount", null);
    private static final MetricName EVENT_QUEUE_TIME_MS = new MetricName("kafka.controller", "ControllerEventManager", "EventQueueTimeMs", null);
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = new MetricName("kafka.controller", "ControllerEventManager", "EventQueueProcessingTimeMs", null);
    private volatile boolean active = false;
    private final Gauge<Integer> activeControllerCount;
    private final Histogram eventQueueTime;
    private final Histogram eventQueueProcessingTime;

    public QuorumControllerMetrics(MetricsRegistry registry) {
        this.activeControllerCount = registry.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        });
        this.eventQueueTime = registry.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTime = registry.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean active() {
        return this.active;
    }

    @Override
    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTime.update(durationMs);
    }

    @Override
    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueTime.update(durationMs);
    }
}

