/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageTestUtil;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class StopReplicaRequestTest {
    @Test
    public void testUnsupportedVersion() {
        StopReplicaRequest.Builder builder = new StopReplicaRequest.Builder((short)(ApiKeys.STOP_REPLICA.latestVersion() + 1), 0, 0, 0L, false, Collections.emptyList());
        Assert.assertThrows(UnsupportedVersionException.class, () -> ((StopReplicaRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        for (short version = ApiKeys.STOP_REPLICA.oldestVersion(); version < ApiKeys.STOP_REPLICA.latestVersion(); version = (short)(version + 1)) {
            StopReplicaRequest.Builder builder = new StopReplicaRequest.Builder(version, 0, 0, 0L, false, Collections.emptyList());
            StopReplicaRequest request = (StopReplicaRequest)builder.build();
            StopReplicaResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assert.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
        }
    }

    @Test
    public void testStopReplicaRequestNormalization() {
        Set<TopicPartition> tps = TestUtils.generateRandomTopicPartitions(10, 10);
        StopReplicaRequest.Builder builder = new StopReplicaRequest.Builder(5, 0, 0, 0L, false, tps);
        Assert.assertTrue((MessageTestUtil.messageSize((Message)builder.build((short)1).data(), (short)1) < MessageTestUtil.messageSize((Message)builder.build((short)0).data(), (short)0) ? 1 : 0) != 0);
    }
}

