/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DeleteGroupsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private DeletableGroupResultCollection results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DeleteGroupsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteGroupsResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public DeleteGroupsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new DeletableGroupResultCollection(0);
    }

    public short apiKey() {
        return 42;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version) {
        int i;
        DeletableGroupResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new DeletableGroupResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeletableGroupResult(_readable, _version));
            }
            this.results = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new DeletableGroupResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeletableGroupResult(_readable, _version));
            }
            this.results = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Iterator iterator;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.results.size() + 1);
            iterator = this.results.iterator();
            while (iterator.hasNext()) {
                DeletableGroupResult resultsElement = (DeletableGroupResult)iterator.next();
                resultsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.results.size());
            iterator = this.results.iterator();
            while (iterator.hasNext()) {
                DeletableGroupResult resultsElement = (DeletableGroupResult)iterator.next();
                resultsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] _nestedObjects = struct.getArray("results");
        this.results = new DeletableGroupResultCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.results.add(new DeletableGroupResult((Struct)nestedObject, _version));
        }
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] _nestedObjects = new Struct[this.results.size()];
        int i = 0;
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            DeletableGroupResult element = (DeletableGroupResult)iterator.next();
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("results", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.results.size() + 1))) : (_arraySize += 4);
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            DeletableGroupResult resultsElement = (DeletableGroupResult)iterator.next();
            _arraySize += resultsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteGroupsResponseData)) {
            return false;
        }
        DeleteGroupsResponseData other = (DeleteGroupsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals((Object)other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DeleteGroupsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString((Iterator)this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DeletableGroupResultCollection results() {
        return this.results;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteGroupsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteGroupsResponseData setResults(DeletableGroupResultCollection v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new ArrayOf((Type)DeletableGroupResult.SCHEMA_0), "The deletion results")});
        SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new CompactArrayOf((Type)DeletableGroupResult.SCHEMA_2), "The deletion results"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DeletableGroupResultCollection
    extends ImplicitLinkedHashMultiCollection<DeletableGroupResult> {
        public DeletableGroupResultCollection() {
        }

        public DeletableGroupResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DeletableGroupResultCollection(Iterator<DeletableGroupResult> iterator) {
            super(iterator);
        }

        public DeletableGroupResult find(String groupId) {
            DeletableGroupResult _key = new DeletableGroupResult();
            _key.setGroupId(groupId);
            return (DeletableGroupResult)this.find(_key);
        }

        public List<DeletableGroupResult> findAll(String groupId) {
            DeletableGroupResult _key = new DeletableGroupResult();
            _key.setGroupId(groupId);
            return this.findAll(_key);
        }
    }

    public static class DeletableGroupResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String groupId;
        private short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DeletableGroupResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeletableGroupResult(Struct struct, short _version) {
            this.fromStruct(struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeletableGroupResult() {
            this.groupId = "";
            this.errorCode = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeletableGroupResult");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _readable.readString(length);
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeletableGroupResult");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.groupId);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeletableGroupResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.groupId = struct.getString("group_id");
            this.errorCode = struct.getShort("error_code");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeletableGroupResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("group_id", (Object)this.groupId);
            struct.set("error_code", (Object)this.errorCode);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeletableGroupResult");
            }
            byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.groupId, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeletableGroupResult)) {
                return false;
            }
            DeletableGroupResult other = (DeletableGroupResult)obj;
            return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DeletableGroupResult(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", errorCode=" + this.errorCode + ")";
        }

        public String groupId() {
            return this.groupId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeletableGroupResult setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public DeletableGroupResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("group_id", (Type)Type.STRING, "The group id"), new Field("error_code", (Type)Type.INT16, "The deletion error, or 0 if the deletion succeeded.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("group_id", (Type)Type.COMPACT_STRING, "The group id"), new Field("error_code", (Type)Type.INT16, "The deletion error, or 0 if the deletion succeeded."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

