/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;

public final class BufferPool {
    private final long totalMemory;
    private final int poolableSize;
    private final ReentrantLock lock;
    private final Deque<ByteBuffer> free;
    private final Deque<Condition> waiters;
    private long availableMemory;
    private final Metrics metrics;
    private final Time time;
    private final Sensor waitTime;

    public BufferPool(long memory, int poolableSize, Metrics metrics, Time time, String metricGrpName, Map<String, String> metricTags) {
        this.poolableSize = poolableSize;
        this.lock = new ReentrantLock();
        this.free = new ArrayDeque<ByteBuffer>();
        this.waiters = new ArrayDeque<Condition>();
        this.totalMemory = memory;
        this.availableMemory = memory;
        this.metrics = metrics;
        this.time = time;
        this.waitTime = this.metrics.sensor("bufferpool-wait-time");
        MetricName metricName = new MetricName("bufferpool-wait-ratio", metricGrpName, "The fraction of time an appender waits for space allocation.", metricTags);
        this.waitTime.add(metricName, new Rate(TimeUnit.NANOSECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocate(int size, long maxTimeToBlock) throws InterruptedException {
        if ((long)size > this.totalMemory) {
            throw new IllegalArgumentException("Attempt to allocate " + size + " bytes, but there is a hard limit of " + this.totalMemory + " on memory allocations.");
        }
        this.lock.lock();
        try {
            if (size == this.poolableSize && !this.free.isEmpty()) {
                ByteBuffer byteBuffer = this.free.pollFirst();
                return byteBuffer;
            }
            int freeListSize = this.free.size() * this.poolableSize;
            if (this.availableMemory + (long)freeListSize >= (long)size) {
                this.freeUp(size);
                this.availableMemory -= (long)size;
                this.lock.unlock();
                ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                return byteBuffer;
            }
            int accumulated = 0;
            ByteBuffer buffer = null;
            Condition moreMemory = this.lock.newCondition();
            this.waiters.addLast(moreMemory);
            while (accumulated < size) {
                long startWait = this.time.nanoseconds();
                if (!moreMemory.await(maxTimeToBlock, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Failed to allocate memory within the configured max blocking time");
                }
                long endWait = this.time.nanoseconds();
                this.waitTime.record(endWait - startWait, this.time.milliseconds());
                if (accumulated == 0 && size == this.poolableSize && !this.free.isEmpty()) {
                    buffer = this.free.pollFirst();
                    accumulated = size;
                    continue;
                }
                this.freeUp(size - accumulated);
                int got = (int)Math.min((long)(size - accumulated), this.availableMemory);
                this.availableMemory -= (long)got;
                accumulated += got;
            }
            Condition removed = this.waiters.removeFirst();
            if (removed != moreMemory) {
                throw new IllegalStateException("Wrong condition: this shouldn't happen.");
            }
            if (!(this.availableMemory <= 0L && this.free.isEmpty() || this.waiters.isEmpty())) {
                this.waiters.peekFirst().signal();
            }
            this.lock.unlock();
            if (buffer == null) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                return byteBuffer;
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    private void freeUp(int size) {
        while (!this.free.isEmpty() && this.availableMemory < (long)size) {
            this.availableMemory += (long)this.free.pollLast().capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(ByteBuffer buffer, int size) {
        this.lock.lock();
        try {
            if (size == this.poolableSize && size == buffer.capacity()) {
                buffer.clear();
                this.free.add(buffer);
            } else {
                this.availableMemory += (long)size;
            }
            Condition moreMem = this.waiters.peekFirst();
            if (moreMem != null) {
                moreMem.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deallocate(ByteBuffer buffer) {
        this.deallocate(buffer, buffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long availableMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory + (long)(this.free.size() * this.poolableSize);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unallocatedMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queued() {
        this.lock.lock();
        try {
            int n = this.waiters.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int poolableSize() {
        return this.poolableSize;
    }

    public long totalMemory() {
        return this.totalMemory;
    }
}

