/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthSchemeProvider;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecProvider;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.RequestCopier;
import org.apache.hc.client5.http.impl.async.AbstractHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;

abstract class InternalAbstractHttpAsyncClient
extends AbstractHttpAsyncClientBase {
    private final AsyncExecChainElement execChain;
    private final Lookup<CookieSpecProvider> cookieSpecRegistry;
    private final Lookup<AuthSchemeProvider> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final RequestConfig defaultConfig;
    private final List<Closeable> closeables;

    InternalAbstractHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, AsyncExecChainElement execChain, Lookup<CookieSpecProvider> cookieSpecRegistry, Lookup<AuthSchemeProvider> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory);
        this.execChain = execChain;
        this.cookieSpecRegistry = cookieSpecRegistry;
        this.authSchemeRegistry = authSchemeRegistry;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.defaultConfig = defaultConfig;
        this.closeables = closeables;
    }

    @Override
    public void close() {
        super.close();
        if (this.closeables != null) {
            for (Closeable closeable : this.closeables) {
                try {
                    closeable.close();
                }
                catch (IOException ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void setupContext(HttpClientContext context) {
        if (context.getAttribute("http.authscheme-registry") == null) {
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        }
        if (context.getAttribute("http.cookiespec-registry") == null) {
            context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        }
        if (context.getAttribute("http.cookie-store") == null) {
            context.setAttribute("http.cookie-store", this.cookieStore);
        }
        if (context.getAttribute("http.auth.credentials-provider") == null) {
            context.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (context.getAttribute("http.request-config") == null) {
            context.setAttribute("http.request-config", this.defaultConfig);
        }
    }

    abstract AsyncExecRuntime crerateAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> var1);

    abstract HttpRoute determineRoute(HttpRequest var1, HttpClientContext var2) throws HttpException;

    @Override
    public <T> Future<T> execute(final AsyncRequestProducer requestProducer, final AsyncResponseConsumer<T> responseConsumer, final HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        this.ensureRunning();
        final ComplexFuture future = new ComplexFuture(callback);
        try {
            final HttpClientContext clientContext = HttpClientContext.adapt(context);
            requestProducer.sendRequest(new RequestChannel(){

                public void sendRequest(HttpRequest request, final EntityDetails entityDetails, final HttpContext context) throws HttpException, IOException {
                    RequestConfig requestConfig = null;
                    if (request instanceof Configurable) {
                        requestConfig = ((Configurable)request).getConfig();
                    }
                    if (requestConfig != null) {
                        clientContext.setRequestConfig(requestConfig);
                    }
                    HttpRoute route = InternalAbstractHttpAsyncClient.this.determineRoute(request, clientContext);
                    final String exchangeId = ExecSupport.getNextExchangeId();
                    final AsyncExecRuntime execRuntime = InternalAbstractHttpAsyncClient.this.crerateAsyncExecRuntime((HandlerFactory<AsyncPushConsumer>)pushHandlerFactory);
                    if (InternalAbstractHttpAsyncClient.this.log.isDebugEnabled()) {
                        InternalAbstractHttpAsyncClient.this.log.debug(exchangeId + ": preparing request execution");
                    }
                    InternalAbstractHttpAsyncClient.this.setupContext(clientContext);
                    AsyncExecChain.Scope scope = new AsyncExecChain.Scope(exchangeId, route, request, (CancellableDependency)future, clientContext, execRuntime);
                    final AtomicBoolean outputTerminated = new AtomicBoolean(false);
                    InternalAbstractHttpAsyncClient.this.execChain.execute(RequestCopier.INSTANCE.copy(request), entityDetails != null ? new AsyncEntityProducer(){

                        public void releaseResources() {
                            requestProducer.releaseResources();
                        }

                        public void failed(Exception cause) {
                            requestProducer.failed(cause);
                        }

                        public boolean isRepeatable() {
                            return requestProducer.isRepeatable();
                        }

                        public long getContentLength() {
                            return entityDetails.getContentLength();
                        }

                        public String getContentType() {
                            return entityDetails.getContentType();
                        }

                        public String getContentEncoding() {
                            return entityDetails.getContentEncoding();
                        }

                        public boolean isChunked() {
                            return entityDetails.isChunked();
                        }

                        public Set<String> getTrailerNames() {
                            return entityDetails.getTrailerNames();
                        }

                        public int available() {
                            return requestProducer.available();
                        }

                        public void produce(DataStreamChannel channel) throws IOException {
                            if (outputTerminated.get()) {
                                channel.endStream();
                                return;
                            }
                            requestProducer.produce(channel);
                        }
                    } : null, scope, new AsyncExecCallback(){

                        @Override
                        public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                            if (response.getCode() >= 400) {
                                outputTerminated.set(true);
                                requestProducer.releaseResources();
                            }
                            responseConsumer.consumeResponse(response, entityDetails, context, new FutureCallback<T>(){

                                public void completed(T result) {
                                    future.completed(result);
                                }

                                public void failed(Exception ex) {
                                    future.failed(ex);
                                }

                                public void cancelled() {
                                    future.cancel();
                                }
                            });
                            return responseConsumer;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void completed() {
                            if (InternalAbstractHttpAsyncClient.this.log.isDebugEnabled()) {
                                InternalAbstractHttpAsyncClient.this.log.debug(exchangeId + ": message exchange successfully completed");
                            }
                            try {
                                execRuntime.releaseEndpoint();
                            }
                            finally {
                                responseConsumer.releaseResources();
                                requestProducer.releaseResources();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void failed(Exception cause) {
                            if (InternalAbstractHttpAsyncClient.this.log.isDebugEnabled()) {
                                InternalAbstractHttpAsyncClient.this.log.debug(exchangeId + ": request failed: " + cause.getMessage());
                            }
                            try {
                                execRuntime.discardEndpoint();
                                responseConsumer.failed(cause);
                            }
                            finally {
                                try {
                                    future.failed(cause);
                                }
                                finally {
                                    responseConsumer.releaseResources();
                                    requestProducer.releaseResources();
                                }
                            }
                        }
                    });
                }
            }, context);
        }
        catch (IOException | HttpException ex) {
            future.failed((Exception)ex);
        }
        return future;
    }
}

