/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.hadoop.hive.llap.cache.EvictionAwareAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileEstimateErrors;

public final class EvictionDispatcher
implements EvictionListener,
LlapOomDebugDump {
    private final LowLevelCache dataCache;
    private final SerDeLowLevelCacheImpl serdeCache;
    private final MetadataCache metadataCache;
    private final EvictionAwareAllocator allocator;

    public EvictionDispatcher(LowLevelCache dataCache, SerDeLowLevelCacheImpl serdeCache, MetadataCache metadataCache, EvictionAwareAllocator allocator) {
        this.dataCache = dataCache;
        this.metadataCache = metadataCache;
        this.serdeCache = serdeCache;
        this.allocator = allocator;
    }

    @Override
    public void notifyEvicted(LlapCacheableBuffer buffer) {
        buffer.notifyEvicted(this);
    }

    public void notifyEvicted(SerDeLowLevelCacheImpl.LlapSerDeDataBuffer buffer) {
        this.serdeCache.notifyEvicted(buffer);
        this.allocator.deallocateEvicted(buffer);
    }

    public void notifyEvicted(LlapDataBuffer buffer) {
        this.dataCache.notifyEvicted(buffer);
        this.allocator.deallocateEvicted(buffer);
    }

    public void notifyEvicted(MetadataCache.LlapMetadataBuffer<?> buffer) {
        this.metadataCache.notifyEvicted(buffer);
        this.allocator.deallocateEvicted(buffer);
    }

    public void notifyEvicted(OrcFileEstimateErrors buffer) {
        this.metadataCache.notifyEvicted(buffer);
    }

    @Override
    public String debugDumpForOom() {
        StringBuilder sb = new StringBuilder(this.dataCache.debugDumpForOom());
        if (this.serdeCache != null) {
            sb.append(this.serdeCache.debugDumpForOom());
        }
        if (this.metadataCache != null) {
            sb.append(this.metadataCache.debugDumpForOom());
        }
        return sb.toString();
    }

    @Override
    public void debugDumpShort(StringBuilder sb) {
        this.dataCache.debugDumpShort(sb);
        if (this.serdeCache != null) {
            this.serdeCache.debugDumpShort(sb);
        }
        if (this.metadataCache != null) {
            this.metadataCache.debugDumpShort(sb);
        }
    }
}

