/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Locale;
import org.apache.flink.runtime.rest.handler.legacy.files.StaticFileServerHandler;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedFile;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HistoryServerStaticFileServerHandler
extends SimpleChannelInboundHandler<RoutedRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryServerStaticFileServerHandler.class);
    private final File rootPath;

    public HistoryServerStaticFileServerHandler(File rootPath) throws IOException {
        this.rootPath = ((File)Preconditions.checkNotNull((Object)rootPath)).getCanonicalFile();
    }

    public void channelRead0(ChannelHandlerContext ctx, RoutedRequest routedRequest) throws Exception {
        String requestPath = routedRequest.getPath();
        this.respondWithFile(ctx, routedRequest.getRequest(), requestPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void respondWithFile(ChannelHandlerContext ctx, HttpRequest request, String requestPath) throws IOException, ParseException {
        block44: {
            if (requestPath.endsWith("/")) {
                requestPath = requestPath + "index.html";
            }
            if (!requestPath.contains(".")) {
                requestPath = requestPath + ".json";
            }
            if ((file = new File(this.rootPath, requestPath)).exists()) break block44;
            cl = HistoryServerStaticFileServerHandler.class.getClassLoader();
            resourceStream = cl.getResourceAsStream("web" + requestPath);
            var7_7 = null;
            try {
                success = false;
                try {
                    if (resourceStream != null) {
                        root = cl.getResource("web");
                        requested = cl.getResource("web" + requestPath);
                        if (root != null && requested != null && !(rootURI = new URI(root.getPath()).normalize()).relativize(requestedURI = new URI(requested.getPath()).normalize()).equals(requestedURI)) {
                            HistoryServerStaticFileServerHandler.LOG.debug("Loading missing file from classloader: {}", (Object)requestPath);
                            file.getParentFile().mkdirs();
                            Files.copy(resourceStream, file.toPath(), new CopyOption[0]);
                            success = true;
                        }
                    }
                    ** if (success) goto lbl-1000
                }
                catch (Throwable t) {
                    block45: {
                        block46: {
                            HistoryServerStaticFileServerHandler.LOG.error("error while responding", t);
                            if (success) break block44;
                            HistoryServerStaticFileServerHandler.LOG.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("File not found."), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
                            if (resourceStream == null) break block45;
                            if (var7_7 == null) break block46;
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable t) {
                                var7_7.addSuppressed(t);
                            }
                            break block45;
                        }
                        resourceStream.close();
                    }
                    return;
                    {
                        catch (Throwable var13_23) {
                            block47: {
                                block48: {
                                    block49: {
                                        if (success) break block47;
                                        HistoryServerStaticFileServerHandler.LOG.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                                        HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("File not found."), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
                                        if (resourceStream == null) break block48;
                                        if (var7_7 == null) break block49;
                                        try {
                                            resourceStream.close();
                                        }
                                        catch (Throwable var14_24) {
                                            var7_7.addSuppressed(var14_24);
                                        }
                                        break block48;
                                    }
                                    resourceStream.close();
                                }
                                return;
                            }
                            try {
                                throw var13_23;
                            }
                            catch (Throwable success) {
                                var7_7 = success;
                                throw success;
                            }
                            catch (Throwable var15_25) {
                                throw var15_25;
                            }
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    HistoryServerStaticFileServerHandler.LOG.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                    HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("File not found."), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
                    return;
                }
lbl-1000:
                // 1 sources

                {
                }
            }
            finally {
                if (resourceStream != null) {
                    if (var7_7 != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable root) {
                            var7_7.addSuppressed(root);
                        }
                    } else {
                        resourceStream.close();
                    }
                }
            }
        }
        if (!file.exists() || file.isHidden() || file.isDirectory() || !file.isFile()) {
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("File not found."), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
            return;
        }
        if (!file.getCanonicalFile().toPath().startsWith(this.rootPath.toPath())) {
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("File not found."), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
            return;
        }
        ifModifiedSince = request.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            if (HistoryServerStaticFileServerHandler.LOG.isDebugEnabled()) {
                HistoryServerStaticFileServerHandler.LOG.debug("Responding 'NOT MODIFIED' for file '" + file.getAbsolutePath() + '\'');
            }
            StaticFileServerHandler.sendNotModified((ChannelHandlerContext)ctx);
            return;
        }
        if (HistoryServerStaticFileServerHandler.LOG.isDebugEnabled()) {
            HistoryServerStaticFileServerHandler.LOG.debug("Responding with file '" + file.getAbsolutePath() + '\'');
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("File not found."), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, Collections.emptyMap());
            return;
        }
        try {
            fileLength = raf.length();
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            StaticFileServerHandler.setContentTypeHeader((HttpResponse)response, (File)file);
            if (!requestPath.equals("/joboverview.json")) {
                StaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, (File)file);
            }
            if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
                response.headers().set("Connection", (Object)"keep-alive");
            }
            HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
            ctx.write((Object)response);
            if (ctx.pipeline().get(SslHandler.class) == null) {
                ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            raf.close();
            HistoryServerStaticFileServerHandler.LOG.error("Failed to serve file.", (Throwable)e);
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)request, (ErrorResponseBody)new ErrorResponseBody("Internal server error."), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, Collections.emptyMap());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isActive()) {
            LOG.error("Caught exception", cause);
            HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (boolean)false, (ErrorResponseBody)new ErrorResponseBody("Internal server error."), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, Collections.emptyMap());
        }
    }
}

