/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.catalog;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.catalog.PostgresTablePath;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectTypeMapper;
import org.apache.flink.connector.jdbc.dialect.psql.PostgresTypeMapper;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PostgresCatalog
extends AbstractJdbcCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresCatalog.class);
    public static final String DEFAULT_DATABASE = "postgres";
    private static final Set<String> builtinDatabases = new HashSet<String>(){
        {
            this.add("template0");
            this.add("template1");
        }
    };
    private static final Set<String> builtinSchemas = new HashSet<String>(){
        {
            this.add("pg_toast");
            this.add("pg_temp_1");
            this.add("pg_toast_temp_1");
            this.add("pg_catalog");
            this.add("information_schema");
        }
    };
    private final JdbcDialectTypeMapper dialectTypeMapper = new PostgresTypeMapper();

    protected PostgresCatalog(String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        super(catalogName, defaultDatabase, username, pwd, baseUrl);
    }

    public List<String> listDatabases() throws CatalogException {
        return this.extractColumnValuesBySQL(this.defaultUrl, "SELECT datname FROM pg_database;", 1, dbName -> !builtinDatabases.contains(dbName), new Object[0]);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)databaseName), (Object)"Database name must not be blank.");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        ArrayList tables = Lists.newArrayList();
        List<String> schemas = this.extractColumnValuesBySQL(this.baseUrl + databaseName, "SELECT schema_name FROM information_schema.schemata;", 1, pgSchema -> !builtinSchemas.contains(pgSchema), new Object[0]);
        for (String schema : schemas) {
            List<String> pureTables = this.extractColumnValuesBySQL(this.baseUrl + databaseName, "SELECT * FROM information_schema.tables WHERE table_type = 'BASE TABLE' AND table_schema = ? ORDER BY table_type, table_name;", 3, null, schema);
            tables.addAll(pureTables.stream().map(pureTable -> schema + "." + pureTable).collect(Collectors.toList()));
        }
        return tables;
    }

    @Override
    protected DataType fromJDBCType(ObjectPath tablePath, ResultSetMetaData metadata, int colIndex) throws SQLException {
        return this.dialectTypeMapper.mapping(tablePath, metadata, colIndex);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        List<String> tables = null;
        try {
            tables = this.listTables(tablePath.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
        return tables.contains(this.getSchemaTableName(tablePath));
    }

    @Override
    protected String getTableName(ObjectPath tablePath) {
        return PostgresTablePath.fromFlinkTableName(tablePath.getObjectName()).getPgTableName();
    }

    @Override
    protected String getSchemaName(ObjectPath tablePath) {
        return PostgresTablePath.fromFlinkTableName(tablePath.getObjectName()).getPgSchemaName();
    }

    @Override
    protected String getSchemaTableName(ObjectPath tablePath) {
        return PostgresTablePath.fromFlinkTableName(tablePath.getObjectName()).getFullPath();
    }
}

