/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class PartitionLoader
implements Closeable {
    private final boolean overwrite;
    private final FileSystem fs;
    private final TableMetaStoreFactory.TableMetaStore metaStore;

    public PartitionLoader(boolean overwrite, FileSystem fs, TableMetaStoreFactory factory) throws Exception {
        this.overwrite = overwrite;
        this.fs = fs;
        this.metaStore = factory.createTableMetaStore();
    }

    public void loadPartition(LinkedHashMap<String, String> partSpec, List<Path> srcDirs) throws Exception {
        Optional<Path> pathFromMeta = this.metaStore.getPartition(partSpec);
        Path path = pathFromMeta.orElseGet(() -> new Path(this.metaStore.getLocationPath(), PartitionPathUtils.generatePartitionPath((LinkedHashMap)partSpec)));
        this.overwriteAndRenameFiles(srcDirs, path);
        this.metaStore.createOrAlterPartition(partSpec, path);
    }

    public void loadNonPartition(List<Path> srcDirs) throws Exception {
        Path tableLocation = this.metaStore.getLocationPath();
        this.overwriteAndRenameFiles(srcDirs, tableLocation);
    }

    private void overwriteAndRenameFiles(List<Path> srcDirs, Path destDir) throws Exception {
        boolean dirSuccessExist = this.fs.exists(destDir) || this.fs.mkdirs(destDir);
        Preconditions.checkState((boolean)dirSuccessExist, (Object)("Failed to create dest path " + destDir));
        this.overwrite(destDir);
        this.renameFiles(srcDirs, destDir);
    }

    private void overwrite(Path destDir) throws Exception {
        FileStatus[] existingFiles;
        if (this.overwrite && (existingFiles = PartitionPathUtils.listStatusWithoutHidden((FileSystem)this.fs, (Path)destDir)) != null) {
            for (FileStatus existingFile : existingFiles) {
                this.fs.delete(existingFile.getPath(), true);
            }
        }
    }

    private void renameFiles(List<Path> srcDirs, Path destDir) throws Exception {
        for (Path srcDir : srcDirs) {
            FileStatus[] srcFiles;
            if (srcDir.equals((Object)destDir) || (srcFiles = PartitionPathUtils.listStatusWithoutHidden((FileSystem)this.fs, (Path)srcDir)) == null) continue;
            for (FileStatus srcFile : srcFiles) {
                Path srcPath = srcFile.getPath();
                Path destPath = new Path(destDir, srcPath.getName());
                this.fs.rename(srcPath, destPath);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.metaStore.close();
    }
}

