/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.context.ModuleExt;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.AbstractConfigManager;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.rpc.model.ModuleModel;

public class ModuleConfigManager
extends AbstractConfigManager
implements ModuleExt {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ModuleConfigManager.class);
    public static final String NAME = "moduleConfig";
    private Map<String, AbstractInterfaceConfig> serviceConfigCache = new ConcurrentHashMap<String, AbstractInterfaceConfig>();
    private final ConfigManager applicationConfigManager;

    public ModuleConfigManager(ModuleModel moduleModel) {
        super(moduleModel, Arrays.asList(ModuleConfig.class, ServiceConfigBase.class, ReferenceConfigBase.class, ProviderConfig.class, ConsumerConfig.class));
        this.applicationConfigManager = moduleModel.getApplicationModel().getApplicationConfigManager();
    }

    @DisableInject
    public void setModule(ModuleConfig module) {
        this.addConfig(module);
    }

    public Optional<ModuleConfig> getModule() {
        return Optional.ofNullable((ModuleConfig)this.getSingleConfig(AbstractConfig.getTagName(ModuleConfig.class)));
    }

    public void addService(ServiceConfigBase<?> serviceConfig) {
        this.addConfig(serviceConfig);
    }

    public void addServices(Iterable<ServiceConfigBase<?>> serviceConfigs) {
        serviceConfigs.forEach(this::addService);
    }

    public Collection<ServiceConfigBase> getServices() {
        return this.getConfigs(AbstractConfig.getTagName(ServiceConfigBase.class));
    }

    public <T> ServiceConfigBase<T> getService(String id) {
        return this.getConfig(ServiceConfigBase.class, id).orElse(null);
    }

    public void addReference(ReferenceConfigBase<?> referenceConfig) {
        this.addConfig(referenceConfig);
    }

    public void addReferences(Iterable<ReferenceConfigBase<?>> referenceConfigs) {
        referenceConfigs.forEach(this::addReference);
    }

    public Collection<ReferenceConfigBase<?>> getReferences() {
        return this.getConfigs(AbstractConfig.getTagName(ReferenceConfigBase.class));
    }

    public <T> ReferenceConfigBase<T> getReference(String id) {
        return this.getConfig(ReferenceConfigBase.class, id).orElse(null);
    }

    public void addProvider(ProviderConfig providerConfig) {
        this.addConfig(providerConfig);
    }

    public void addProviders(Iterable<ProviderConfig> providerConfigs) {
        providerConfigs.forEach(this::addProvider);
    }

    public Optional<ProviderConfig> getProvider(String id) {
        return this.getConfig(ProviderConfig.class, id);
    }

    public Optional<ProviderConfig> getDefaultProvider() {
        List providerConfigs = ModuleConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ProviderConfig.class)));
        if (CollectionUtils.isNotEmpty(providerConfigs)) {
            return Optional.of((ProviderConfig)providerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ProviderConfig> getProviders() {
        return this.getConfigs(AbstractConfig.getTagName(ProviderConfig.class));
    }

    public void addConsumer(ConsumerConfig consumerConfig) {
        this.addConfig(consumerConfig);
    }

    public void addConsumers(Iterable<ConsumerConfig> consumerConfigs) {
        consumerConfigs.forEach(this::addConsumer);
    }

    public Optional<ConsumerConfig> getConsumer(String id) {
        return this.getConfig(ConsumerConfig.class, id);
    }

    public Optional<ConsumerConfig> getDefaultConsumer() {
        List consumerConfigs = ModuleConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConsumerConfig.class)));
        if (CollectionUtils.isNotEmpty(consumerConfigs)) {
            return Optional.of((ConsumerConfig)consumerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ConsumerConfig> getConsumers() {
        return this.getConfigs(AbstractConfig.getTagName(ConsumerConfig.class));
    }

    @Override
    public void refreshAll() {
        this.getModule().ifPresent(AbstractConfig::refresh);
        this.getProviders().forEach(AbstractConfig::refresh);
        this.getConsumers().forEach(AbstractConfig::refresh);
        this.getReferences().forEach(AbstractConfig::refresh);
        this.getServices().forEach(AbstractConfig::refresh);
    }

    @Override
    public void clear() {
        super.clear();
        this.serviceConfigCache.clear();
    }

    @Override
    protected <C extends AbstractConfig> Optional<C> findDuplicatedConfig(Map<String, C> configsMap, C config) {
        if (config instanceof ReferenceConfigBase || config instanceof ServiceConfigBase) {
            AbstractInterfaceConfig existedConfig = this.findDuplicatedInterfaceConfig((AbstractInterfaceConfig)config);
            if (existedConfig != null) {
                return Optional.of(existedConfig);
            }
        } else {
            return super.findDuplicatedConfig(configsMap, config);
        }
        return Optional.empty();
    }

    @Override
    protected <C extends AbstractConfig> boolean removeIfAbsent(C config, Map<String, C> configsMap) {
        if (super.removeIfAbsent(config, configsMap)) {
            if (config instanceof ReferenceConfigBase || config instanceof ServiceConfigBase) {
                this.removeInterfaceConfig((AbstractInterfaceConfig)config);
            }
            return true;
        }
        return false;
    }

    private AbstractInterfaceConfig findDuplicatedInterfaceConfig(AbstractInterfaceConfig config) {
        if (config instanceof ReferenceConfigBase) {
            return null;
        }
        if (!(config instanceof ServiceConfigBase)) {
            throw new IllegalArgumentException("Illegal type of parameter 'config' : " + config.getClass().getName());
        }
        ServiceConfigBase serviceConfig = (ServiceConfigBase)config;
        String uniqueServiceName = serviceConfig.getUniqueServiceName();
        Map<String, AbstractInterfaceConfig> configCache = this.serviceConfigCache;
        AbstractInterfaceConfig prevConfig = configCache.putIfAbsent(uniqueServiceName, config);
        if (prevConfig != null) {
            if (prevConfig == config) {
                return prevConfig;
            }
            if (prevConfig.equals(config)) {
                if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                    logger.warn("0-12", "", "", "Ignore duplicated and equal config: " + config);
                }
                return prevConfig;
            }
            String configType = config.getClass().getSimpleName();
            String msg = "Found multiple " + configType + "s with unique service name [" + uniqueServiceName + "], previous: " + prevConfig + ", later: " + config + ". There can only be one instance of " + configType + " with the same triple (group, interface, version). If multiple instances are required for the same interface, please use a different group or version.";
            if (logger.isWarnEnabled() && this.duplicatedConfigs.add(config)) {
                logger.warn("0-12", "", "", msg);
            }
            if (!this.ignoreDuplicatedInterface) {
                throw new IllegalStateException(msg);
            }
        }
        return prevConfig;
    }

    private void removeInterfaceConfig(AbstractInterfaceConfig config) {
        if (config instanceof ReferenceConfigBase) {
            return;
        }
        if (!(config instanceof ServiceConfigBase)) {
            throw new IllegalArgumentException("Illegal type of parameter 'config' : " + config.getClass().getName());
        }
        ServiceConfigBase serviceConfig = (ServiceConfigBase)config;
        String uniqueServiceName = serviceConfig.getUniqueServiceName();
        Map<String, AbstractInterfaceConfig> configCache = this.serviceConfigCache;
        configCache.remove(uniqueServiceName, config);
    }

    @Override
    public void loadConfigs() {
        this.loadConfigsOfTypeFromProps(ProviderConfig.class);
        this.loadConfigsOfTypeFromProps(ConsumerConfig.class);
        this.loadConfigsOfTypeFromProps(ModuleConfig.class);
        this.checkDefaultAndValidateConfigs(ProviderConfig.class);
        this.checkDefaultAndValidateConfigs(ConsumerConfig.class);
        this.checkDefaultAndValidateConfigs(ModuleConfig.class);
    }

    public ConfigManager getApplicationConfigManager() {
        return this.applicationConfigManager;
    }

    @Override
    public <C extends AbstractConfig> Map<String, C> getConfigsMap(Class<C> cls) {
        if (this.isSupportConfigType(cls)) {
            return super.getConfigsMap(cls);
        }
        return this.applicationConfigManager.getConfigsMap(cls);
    }

    @Override
    public <C extends AbstractConfig> Collection<C> getConfigs(Class<C> configType) {
        if (this.isSupportConfigType(configType)) {
            return super.getConfigs(configType);
        }
        return this.applicationConfigManager.getConfigs(configType);
    }

    @Override
    public <T extends AbstractConfig> Optional<T> getConfig(Class<T> cls, String idOrName) {
        if (this.isSupportConfigType(cls)) {
            return super.getConfig(cls, idOrName);
        }
        return this.applicationConfigManager.getConfig(cls, idOrName);
    }

    @Override
    public <C extends AbstractConfig> List<C> getDefaultConfigs(Class<C> cls) {
        if (this.isSupportConfigType(cls)) {
            return super.getDefaultConfigs(cls);
        }
        return this.applicationConfigManager.getDefaultConfigs(cls);
    }

    public Optional<ApplicationConfig> getApplication() {
        return this.applicationConfigManager.getApplication();
    }

    public Optional<MonitorConfig> getMonitor() {
        return this.applicationConfigManager.getMonitor();
    }

    public Optional<MetricsConfig> getMetrics() {
        return this.applicationConfigManager.getMetrics();
    }

    public Optional<SslConfig> getSsl() {
        return this.applicationConfigManager.getSsl();
    }

    public Optional<Collection<ConfigCenterConfig>> getDefaultConfigCenter() {
        return this.applicationConfigManager.getDefaultConfigCenter();
    }

    public Optional<ConfigCenterConfig> getConfigCenter(String id) {
        return this.applicationConfigManager.getConfigCenter(id);
    }

    public Collection<ConfigCenterConfig> getConfigCenters() {
        return this.applicationConfigManager.getConfigCenters();
    }

    public Collection<MetadataReportConfig> getMetadataConfigs() {
        return this.applicationConfigManager.getMetadataConfigs();
    }

    public Collection<MetadataReportConfig> getDefaultMetadataConfigs() {
        return this.applicationConfigManager.getDefaultMetadataConfigs();
    }

    public Optional<ProtocolConfig> getProtocol(String idOrName) {
        return this.applicationConfigManager.getProtocol(idOrName);
    }

    public List<ProtocolConfig> getDefaultProtocols() {
        return this.applicationConfigManager.getDefaultProtocols();
    }

    public Collection<ProtocolConfig> getProtocols() {
        return this.applicationConfigManager.getProtocols();
    }

    public Optional<RegistryConfig> getRegistry(String id) {
        return this.applicationConfigManager.getRegistry(id);
    }

    public List<RegistryConfig> getDefaultRegistries() {
        return this.applicationConfigManager.getDefaultRegistries();
    }

    public Collection<RegistryConfig> getRegistries() {
        return this.applicationConfigManager.getRegistries();
    }
}

