/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.common.json.JSON;
import org.apache.dubbo.common.json.impl.AbstractJSONImpl;
import org.apache.dubbo.common.json.impl.FastJsonImpl;
import org.apache.dubbo.common.json.impl.GsonImpl;
import org.apache.dubbo.common.utils.StringUtils;

public class JsonUtils {
    private static volatile JSON json;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSON getJson() {
        if (json != null) return json;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (json != null) return json;
            String preferJsonFrameworkName = System.getProperty("dubbo.json-framework.prefer");
            if (StringUtils.isNotEmpty(preferJsonFrameworkName)) {
                try {
                    AbstractJSONImpl instance = null;
                    switch (preferJsonFrameworkName) {
                        case "fastjson": {
                            instance = new FastJsonImpl();
                            break;
                        }
                        case "gson": {
                            instance = new GsonImpl();
                        }
                    }
                    if (instance != null && instance.isSupport()) {
                        json = instance;
                    }
                }
                catch (Throwable instance) {
                    // empty catch block
                }
            }
            if (json == null) {
                List<Class> jsonClasses = Arrays.asList(FastJsonImpl.class, GsonImpl.class);
                for (Class jsonClass : jsonClasses) {
                    try {
                        JSON instance = (JSON)jsonClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!instance.isSupport()) continue;
                        json = instance;
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            if (json != null) return json;
            throw new IllegalStateException("Dubbo unable to find out any json framework (e.g. fastjson, gson) from jvm env. Please import at least one json framework.");
        }
    }

    @Deprecated
    protected static void setJson(JSON json) {
        JsonUtils.json = json;
    }
}

