/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionSelectors;

public class ExpressionVirtualColumn
implements VirtualColumn {
    private final String name;
    private final String expression;
    private final ValueType outputType;
    private final Supplier<Expr> parsedExpression;

    @JsonCreator
    public ExpressionVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JsonProperty(value="outputType") ValueType outputType, @JacksonInject ExprMacroTable macroTable) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.expression = (String)Preconditions.checkNotNull((Object)expression, (Object)"expression");
        this.outputType = outputType != null ? outputType : ValueType.FLOAT;
        this.parsedExpression = Suppliers.memoize(() -> Parser.parse((String)expression, (ExprMacroTable)macroTable));
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty
    public ValueType getOutputType() {
        return this.outputType;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory columnSelectorFactory) {
        return dimensionSpec.decorate(ExpressionSelectors.makeDimensionSelector(columnSelectorFactory, (Expr)this.parsedExpression.get(), dimensionSpec.getExtractionFn()));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return ExpressionSelectors.makeColumnValueSelector(factory, (Expr)this.parsedExpression.get());
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return new ColumnCapabilitiesImpl().setType(this.outputType).setHasMultipleValues(true);
    }

    @Override
    public List<String> requiredColumns() {
        return ((Expr)this.parsedExpression.get()).analyzeInputs().getRequiredBindingsList();
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(1).appendString(this.name).appendString(this.expression).appendString(this.outputType.toString()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionVirtualColumn that = (ExpressionVirtualColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && this.outputType == that.outputType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.expression, this.outputType});
    }

    public String toString() {
        return "ExpressionVirtualColumn{name='" + this.name + '\'' + ", expression='" + this.expression + '\'' + ", outputType=" + (Object)((Object)this.outputType) + '}';
    }
}

