/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.RowOffsetMatcherFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class OrFilter
implements BooleanFilter {
    private static final Joiner OR_JOINER = Joiner.on((String)" || ");
    private final List<Filter> filters;

    public OrFilter(List<Filter> filters) {
        Preconditions.checkArgument((filters.size() > 0 ? 1 : 0) != 0, (Object)"Can't construct empty OrFilter (the universe does not exist)");
        this.filters = filters;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getBitmapResult(selector, bitmapResultFactory);
        }
        ArrayList<T> bitmapResults = new ArrayList<T>();
        for (Filter filter : this.filters) {
            bitmapResults.add(filter.getBitmapResult(selector, bitmapResultFactory));
        }
        return bitmapResultFactory.union(bitmapResults);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        return OrFilter.makeMatcher(matchers);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        VectorValueMatcher[] matchers = new VectorValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeVectorMatcher(factory);
        }
        return OrFilter.makeVectorMatcher(matchers);
    }

    @Override
    public boolean canVectorizeMatcher() {
        return this.filters.stream().allMatch(Filter::canVectorizeMatcher);
    }

    @Override
    public ValueMatcher makeMatcher(BitmapIndexSelector selector, ColumnSelectorFactory columnSelectorFactory, RowOffsetMatcherFactory rowOffsetMatcherFactory) {
        ArrayList<ValueMatcher> matchers = new ArrayList<ValueMatcher>();
        ArrayList<ImmutableBitmap> bitmaps = new ArrayList<ImmutableBitmap>();
        for (Filter filter : this.filters) {
            if (filter.supportsBitmapIndex(selector)) {
                bitmaps.add(filter.getBitmapIndex(selector));
                continue;
            }
            ValueMatcher matcher = filter.makeMatcher(columnSelectorFactory);
            matchers.add(matcher);
        }
        if (bitmaps.size() > 0) {
            ImmutableBitmap combinedBitmap = selector.getBitmapFactory().union(bitmaps);
            ValueMatcher offsetMatcher = rowOffsetMatcherFactory.makeRowOffsetMatcher(combinedBitmap);
            matchers.add(0, offsetMatcher);
        }
        return OrFilter.makeMatcher(matchers.toArray(AndFilter.EMPTY_VALUE_MATCHER_ARRAY));
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        double selectivity = 0.0;
        for (Filter filter : this.filters) {
            selectivity += filter.estimateSelectivity(indexSelector);
        }
        return Math.min(selectivity, 1.0);
    }

    public String toString() {
        return StringUtils.format((String)"(%s)", (Object[])new Object[]{OR_JOINER.join(this.filters)});
    }

    private static ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (!matcher.matches()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("firstBaseMatcher", baseMatchers[0]);
                inspector.visit("secondBaseMatcher", baseMatchers[1]);
            }
        };
    }

    private static VectorValueMatcher makeVectorMatcher(final VectorValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new BaseVectorValueMatcher(baseMatchers[0]){
            final VectorMatch currentMask;
            final VectorMatch scratch;
            final VectorMatch retVal;
            {
                super(selector);
                this.currentMask = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
                this.scratch = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
                this.retVal = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                ReadableVectorMatch currentMatch = baseMatchers[0].match(mask);
                this.currentMask.copyFrom(mask);
                this.retVal.copyFrom(currentMatch);
                for (int i = 1; i < baseMatchers.length && !this.retVal.isAllTrue(this.getCurrentVectorSize()); ++i) {
                    this.currentMask.removeAll(currentMatch);
                    currentMatch = baseMatchers[i].match(this.currentMask);
                    this.retVal.addAll(currentMatch, this.scratch);
                }
                assert (this.retVal.isValid(mask));
                return this.retVal;
            }
        };
    }
}

