/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.StringDimensionIndexer;
import org.apache.druid.segment.StringDimensionMergerV9;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableDimensionValueSelector;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class StringDimensionHandler
implements DimensionHandler<Integer, int[], String> {
    private static final Comparator<ColumnValueSelector> DIMENSION_SELECTOR_COMPARATOR = (s1, s2) -> {
        IndexedInts row1 = StringDimensionHandler.getRow(s1);
        IndexedInts row2 = StringDimensionHandler.getRow(s2);
        int len1 = row1.size();
        int len2 = row2.size();
        boolean row1IsNull = true;
        boolean row2IsNull = true;
        for (int i = 0; i < Math.min(len1, len2); ++i) {
            int v1 = row1.get(i);
            row1IsNull &= v1 == 0;
            int v2 = row2.get(i);
            row2IsNull &= v2 == 0;
            int valueDiff = Integer.compare(v1, v2);
            if (valueDiff == 0) continue;
            return valueDiff;
        }
        int lenDiff = len1 - len2;
        if (lenDiff == 0) {
            return 0;
        }
        if (!row1IsNull || !row2IsNull) {
            return lenDiff;
        }
        return StringDimensionHandler.compareRestNulls(row1, len1, row2, len2);
    };
    private final String dimensionName;
    private final DimensionSchema.MultiValueHandling multiValueHandling;
    private final boolean hasBitmapIndexes;

    private static int compareRestNulls(IndexedInts row1, int len1, IndexedInts row2, int len2) {
        if (len1 < len2) {
            for (int i = len1; i < len2; ++i) {
                if (row2.get(i) == 0) continue;
                return -1;
            }
        } else {
            for (int i = len2; i < len1; ++i) {
                if (row1.get(i) == 0) continue;
                return 1;
            }
        }
        return 0;
    }

    private static IndexedInts getRow(ColumnValueSelector s) {
        if (s instanceof DimensionSelector) {
            return ((DimensionSelector)s).getRow();
        }
        if (s instanceof NilColumnValueSelector) {
            return ZeroIndexedInts.instance();
        }
        throw new ISE("ColumnValueSelector[%s], only DimensionSelector or NilColumnValueSelector is supported", new Object[]{s.getClass()});
    }

    public StringDimensionHandler(String dimensionName, DimensionSchema.MultiValueHandling multiValueHandling, boolean hasBitmapIndexes) {
        this.dimensionName = dimensionName;
        this.multiValueHandling = multiValueHandling;
        this.hasBitmapIndexes = hasBitmapIndexes;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionSchema.MultiValueHandling getMultivalueHandling() {
        return this.multiValueHandling;
    }

    @Override
    public int getLengthOfEncodedKeyComponent(int[] dimVals) {
        return dimVals.length;
    }

    @Override
    public Comparator<ColumnValueSelector> getEncodedValueSelectorComparator() {
        return DIMENSION_SELECTOR_COMPARATOR;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableEncodedValueSelector() {
        return new SettableDimensionValueSelector();
    }

    @Override
    public DimensionIndexer<Integer, int[], String> makeIndexer() {
        return new StringDimensionIndexer(this.multiValueHandling, this.hasBitmapIndexes);
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        if (this.hasBitmapIndexes != capabilities.hasBitmapIndexes()) {
            throw new ISE("capabilities.hasBitmapIndexes[%s] != this.hasBitmapIndexes[%s]", new Object[]{capabilities.hasBitmapIndexes(), this.hasBitmapIndexes});
        }
        return new StringDimensionMergerV9(this.dimensionName, indexSpec, segmentWriteOutMedium, capabilities, progress, closer);
    }
}

