/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.MetricHolder;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.joda.time.Interval;

public class MMappedIndex {
    final GenericIndexed<String> availableDimensions;
    final GenericIndexed<String> availableMetrics;
    final Interval dataInterval;
    final CompressedColumnarLongsSupplier timestamps;
    final Map<String, MetricHolder> metrics;
    final Map<String, GenericIndexed<String>> dimValueLookups;
    final Map<String, VSizeColumnarMultiInts> dimColumns;
    final Map<String, GenericIndexed<ImmutableBitmap>> invertedIndexes;
    final Map<String, ImmutableRTree> spatialIndexes;
    final SmooshedFileMapper fileMapper;

    public MMappedIndex(GenericIndexed<String> availableDimensions, GenericIndexed<String> availableMetrics, Interval dataInterval, CompressedColumnarLongsSupplier timestamps, Map<String, MetricHolder> metrics, Map<String, GenericIndexed<String>> dimValueLookups, Map<String, VSizeColumnarMultiInts> dimColumns, Map<String, GenericIndexed<ImmutableBitmap>> invertedIndexes, Map<String, ImmutableRTree> spatialIndexes, SmooshedFileMapper fileMapper) {
        this.availableDimensions = availableDimensions;
        this.availableMetrics = availableMetrics;
        this.dataInterval = dataInterval;
        this.timestamps = timestamps;
        this.metrics = metrics;
        this.dimValueLookups = dimValueLookups;
        this.dimColumns = dimColumns;
        this.invertedIndexes = invertedIndexes;
        this.spatialIndexes = spatialIndexes;
        this.fileMapper = fileMapper;
    }

    public GenericIndexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    public GenericIndexed<String> getAvailableMetrics() {
        return this.availableMetrics;
    }

    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Nullable
    public MetricHolder getMetricHolder(String metric) {
        return this.metrics.get(metric);
    }

    public GenericIndexed<String> getDimValueLookup(String dimension) {
        return this.dimValueLookups.get(dimension);
    }

    public VSizeColumnarMultiInts getDimColumn(String dimension) {
        return this.dimColumns.get(dimension);
    }

    public Map<String, GenericIndexed<ImmutableBitmap>> getBitmapIndexes() {
        return this.invertedIndexes;
    }

    public Map<String, ImmutableRTree> getSpatialIndexes() {
        return this.spatialIndexes;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }
}

