/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.util.Map;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ValueType;

public class DimValHolder {
    private final Object topNMetricVal;
    private final Comparable dimValue;
    private final Object dimValIndex;
    private final Map<String, Object> metricValues;

    public DimValHolder(Object topNMetricVal, Comparable dimValue, Object dimValIndex, Map<String, Object> metricValues) {
        this.topNMetricVal = topNMetricVal;
        this.dimValue = dimValue;
        this.dimValIndex = dimValIndex;
        this.metricValues = metricValues;
    }

    public Object getTopNMetricVal() {
        return this.topNMetricVal;
    }

    public Comparable getDimValue() {
        return this.dimValue;
    }

    public Object getDimValIndex() {
        return this.dimValIndex;
    }

    public Map<String, Object> getMetricValues() {
        return this.metricValues;
    }

    public static class Builder {
        private Object topNMetricVal = null;
        private Comparable dimValue = null;
        private Object dimValIndex = null;
        private Map<String, Object> metricValues = null;

        public Builder withTopNMetricVal(Object topNMetricVal) {
            this.topNMetricVal = topNMetricVal;
            return this;
        }

        public Builder withDimValue(Comparable dimValue, ValueType type) {
            this.dimValue = DimensionHandlerUtils.convertObjectToType(dimValue, type);
            return this;
        }

        public Builder withDimValIndex(Object dimValIndex) {
            this.dimValIndex = dimValIndex;
            return this;
        }

        public Builder withMetricValues(Map<String, Object> metricValues) {
            this.metricValues = metricValues;
            return this;
        }

        public DimValHolder build() {
            return new DimValHolder(this.topNMetricVal, this.dimValue, this.dimValIndex, this.metricValues);
        }
    }
}

