/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Predicate;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueGetter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;

public class StringValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<DimensionSelector> {
    private static final String[] NULL_VALUE = new String[]{null};
    private static final ValueGetter NULL_VALUE_GETTER = () -> NULL_VALUE;
    private final boolean hasMultipleValues;

    public StringValueMatcherColumnSelectorStrategy(boolean hasMultipleValues) {
        this.hasMultipleValues = hasMultipleValues;
    }

    @Nullable
    public static Boolean toBooleanIfPossible(DimensionDictionarySelector selector, boolean hasMultipleValues, Predicate<String> predicate) {
        if (selector.getValueCardinality() == 0) {
            return predicate.apply(null);
        }
        if (!hasMultipleValues && selector.getValueCardinality() == 1 && selector.nameLookupPossibleInAdvance()) {
            return predicate.apply((Object)selector.lookupName(0));
        }
        return null;
    }

    @Nullable
    private static ValueMatcher toBooleanMatcherIfPossible(DimensionSelector selector, boolean hasMultipleValues, Predicate<String> predicate) {
        Boolean booleanValue = StringValueMatcherColumnSelectorStrategy.toBooleanIfPossible(selector, hasMultipleValues, predicate);
        return booleanValue == null ? null : BooleanValueMatcher.of(booleanValue);
    }

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, String value) {
        ValueMatcher booleanMatcher = StringValueMatcherColumnSelectorStrategy.toBooleanMatcherIfPossible(selector, this.hasMultipleValues, (Predicate<String>)((Predicate)s -> Objects.equals(s, NullHandling.emptyToNullIfNeeded((String)value))));
        if (booleanMatcher != null) {
            return booleanMatcher;
        }
        return selector.makeValueMatcher(value);
    }

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, DruidPredicateFactory predicateFactory) {
        Predicate<String> predicate = predicateFactory.makeStringPredicate();
        ValueMatcher booleanMatcher = StringValueMatcherColumnSelectorStrategy.toBooleanMatcherIfPossible(selector, this.hasMultipleValues, predicate);
        if (booleanMatcher != null) {
            return booleanMatcher;
        }
        return selector.makeValueMatcher(predicate);
    }

    @Override
    public ValueGetter makeValueGetter(DimensionSelector selector) {
        if (selector.getValueCardinality() == 0) {
            return NULL_VALUE_GETTER;
        }
        return () -> {
            IndexedInts row = selector.getRow();
            int size = row.size();
            if (size == 0) {
                return NULL_VALUE;
            }
            String[] values = new String[size];
            for (int i = 0; i < size; ++i) {
                values[i] = selector.lookupName(row.get(i));
            }
            return values;
        };
    }
}

