/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampFormatExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "timestamp_format";
    }

    public Expr apply(List<Expr> args) {
        String formatString;
        if (args.size() < 1 || args.size() > 3) {
            throw new IAE("Function[%s] must have 1 to 3 arguments", new Object[]{this.name()});
        }
        Expr arg = args.get(0);
        if (args.size() > 1) {
            Preconditions.checkArgument((boolean)args.get(1).isLiteral(), (String)"Function[%s] format arg must be a literal", (Object[])new Object[]{this.name()});
            formatString = (String)args.get(1).getLiteralValue();
        } else {
            formatString = null;
        }
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        DateTimeFormatter formatter = formatString == null ? ISODateTimeFormat.dateTime() : DateTimeFormat.forPattern(formatString).withZone(timeZone);
        class TimestampFormatExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ DateTimeFormatter val$formatter;

            TimestampFormatExpr(Expr arg) {
                this.val$formatter = dateTimeFormatter;
                super(arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = this.arg.eval(bindings);
                if (eval.isNumericNull()) {
                    return ExprEval.of(null);
                }
                return ExprEval.of((String)this.val$formatter.print(this.arg.eval(bindings).asLong()));
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new TimestampFormatExpr(newArg));
            }
        }
        return new TimestampFormatExpr(arg);
    }
}

