/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseNullableColumnValueSelector;

public abstract class NumericFirstAggregator<TSelector extends BaseNullableColumnValueSelector>
implements Aggregator {
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final BaseLongColumnValueSelector timeSelector;
    final TSelector valueSelector;
    long firstTime;
    boolean rhsNull;

    public NumericFirstAggregator(BaseLongColumnValueSelector timeSelector, TSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.firstTime = Long.MAX_VALUE;
        this.rhsNull = !this.useDefault;
    }

    abstract void setCurrentValue();

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            if (this.useDefault || !this.valueSelector.isNull()) {
                this.setCurrentValue();
                this.rhsNull = false;
            } else {
                this.rhsNull = true;
            }
        }
    }

    @Override
    public void close() {
    }
}

