/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.types;

import com.google.common.hash.Hasher;
import java.util.Arrays;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class StringCardinalityAggregatorColumnSelectorStrategy
implements CardinalityAggregatorColumnSelectorStrategy<DimensionSelector> {
    public static final String CARDINALITY_AGG_NULL_STRING = "\u0000";
    public static final char CARDINALITY_AGG_SEPARATOR = '\u0001';

    @Override
    public void hashRow(DimensionSelector dimSelector, Hasher hasher) {
        IndexedInts row = dimSelector.getRow();
        int size = row.size();
        if (size == 1) {
            String value = dimSelector.lookupName(row.get(0));
            if (NullHandling.replaceWithDefault() || value != null) {
                hasher.putUnencodedChars((CharSequence)this.nullToSpecial(value));
            }
        } else if (size != 0) {
            int i;
            boolean hasNonNullValue = false;
            Object[] values = new String[size];
            for (i = 0; i < size; ++i) {
                String value = dimSelector.lookupName(row.get(i));
                if (NullHandling.sqlCompatible() && !hasNonNullValue && value != null) {
                    hasNonNullValue = true;
                }
                values[i] = this.nullToSpecial(value);
            }
            if (NullHandling.replaceWithDefault() || hasNonNullValue) {
                Arrays.sort(values);
                for (i = 0; i < size; ++i) {
                    if (i != 0) {
                        hasher.putChar('\u0001');
                    }
                    hasher.putUnencodedChars((CharSequence)values[i]);
                }
            }
        }
    }

    @Override
    public void hashValues(DimensionSelector dimSelector, HyperLogLogCollector collector) {
        IndexedInts row = dimSelector.getRow();
        int rowSize = row.size();
        for (int i = 0; i < rowSize; ++i) {
            int index = row.get(i);
            String value = dimSelector.lookupName(index);
            if (!NullHandling.replaceWithDefault() && value == null) continue;
            collector.add(CardinalityAggregator.HASH_FUNCTION.hashUnencodedChars((CharSequence)this.nullToSpecial(value)).asBytes());
        }
    }

    private String nullToSpecial(String value) {
        return value == null ? CARDINALITY_AGG_NULL_STRING : value;
    }
}

