/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleMinAggregateCombiner;
import org.apache.druid.query.aggregation.DoubleMinAggregator;
import org.apache.druid.query.aggregation.DoubleMinBufferAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleMinAggregatorFactory
extends SimpleDoubleAggregatorFactory {
    @JsonCreator
    public DoubleMinAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") @Nullable String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
    }

    public DoubleMinAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    protected double nullValue() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected Aggregator buildAggregator(BaseDoubleColumnValueSelector selector) {
        return new DoubleMinAggregator(selector);
    }

    @Override
    protected BufferAggregator buildBufferAggregator(BaseDoubleColumnValueSelector selector) {
        return new DoubleMinBufferAggregator(selector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return DoubleMinAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleMinAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleMinAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DoubleMinAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty((String)this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty((String)this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)4).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "DoubleMinAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

