/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class AggregatorAdapters
implements Closeable {
    private static final Logger log = new Logger(AggregatorAdapters.class);
    private final List<Adapter> adapters;
    private final List<AggregatorFactory> factories;
    private final int[] aggregatorPositions;
    private final int spaceNeeded;

    private AggregatorAdapters(List<Adapter> adapters) {
        this.adapters = adapters;
        this.factories = adapters.stream().map(Adapter::getFactory).collect(Collectors.toList());
        this.aggregatorPositions = new int[adapters.size()];
        long nextPosition = 0L;
        for (int i = 0; i < adapters.size(); ++i) {
            AggregatorFactory aggregatorFactory = adapters.get(i).getFactory();
            this.aggregatorPositions[i] = Ints.checkedCast((long)nextPosition);
            nextPosition += (long)aggregatorFactory.getMaxIntermediateSizeWithNulls();
        }
        this.spaceNeeded = Ints.checkedCast((long)nextPosition);
    }

    public static AggregatorAdapters factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, List<AggregatorFactory> aggregatorFactories) {
        Adapter[] adapters = new Adapter[aggregatorFactories.size()];
        for (int i = 0; i < aggregatorFactories.size(); ++i) {
            AggregatorFactory aggregatorFactory = aggregatorFactories.get(i);
            adapters[i] = new VectorAggregatorAdapter(aggregatorFactory, aggregatorFactory.factorizeVector(columnSelectorFactory));
        }
        return new AggregatorAdapters(Arrays.asList(adapters));
    }

    public static AggregatorAdapters factorizeBuffered(ColumnSelectorFactory columnSelectorFactory, List<AggregatorFactory> aggregatorFactories) {
        Adapter[] adapters = new Adapter[aggregatorFactories.size()];
        for (int i = 0; i < aggregatorFactories.size(); ++i) {
            AggregatorFactory aggregatorFactory = aggregatorFactories.get(i);
            adapters[i] = new BufferAggregatorAdapter(aggregatorFactory, aggregatorFactory.factorizeBuffered(columnSelectorFactory));
        }
        return new AggregatorAdapters(Arrays.asList(adapters));
    }

    public int spaceNeeded() {
        return this.spaceNeeded;
    }

    public List<AggregatorFactory> factories() {
        return this.factories;
    }

    public int[] aggregatorPositions() {
        return this.aggregatorPositions;
    }

    public int size() {
        return this.adapters.size();
    }

    public void init(ByteBuffer buf, int position) {
        for (int i = 0; i < this.adapters.size(); ++i) {
            this.adapters.get(i).init(buf, position + this.aggregatorPositions[i]);
        }
    }

    public void aggregateBuffered(ByteBuffer buf, int position) {
        for (int i = 0; i < this.adapters.size(); ++i) {
            Adapter adapter = this.adapters.get(i);
            adapter.asBufferAggregator().aggregate(buf, position + this.aggregatorPositions[i]);
        }
    }

    public void aggregateVector(ByteBuffer buf, int position, int start, int end) {
        for (int i = 0; i < this.adapters.size(); ++i) {
            Adapter adapter = this.adapters.get(i);
            adapter.asVectorAggregator().aggregate(buf, position + this.aggregatorPositions[i], start, end);
        }
    }

    public void aggregateVector(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows) {
        for (int i = 0; i < this.adapters.size(); ++i) {
            Adapter adapter = this.adapters.get(i);
            adapter.asVectorAggregator().aggregate(buf, numRows, positions, rows, this.aggregatorPositions[i]);
        }
    }

    @Nullable
    public Object get(ByteBuffer buf, int position, int aggregatorNumber) {
        return this.adapters.get(aggregatorNumber).get(buf, position + this.aggregatorPositions[aggregatorNumber]);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        for (int i = 0; i < this.adapters.size(); ++i) {
            this.adapters.get(i).relocate(oldPosition + this.aggregatorPositions[i], newPosition + this.aggregatorPositions[i], oldBuffer, newBuffer);
        }
    }

    @Override
    public void close() {
        for (Adapter adapter : this.adapters) {
            try {
                adapter.close();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Could not close aggregator [%s], skipping.", new Object[]{adapter.getFactory().getName()});
            }
        }
    }

    private static class BufferAggregatorAdapter
    implements Adapter {
        private final AggregatorFactory factory;
        private final BufferAggregator aggregator;

        BufferAggregatorAdapter(AggregatorFactory factory, BufferAggregator aggregator) {
            this.factory = factory;
            this.aggregator = aggregator;
        }

        @Override
        public void init(ByteBuffer buf, int position) {
            this.aggregator.init(buf, position);
        }

        @Override
        public Object get(ByteBuffer buf, int position) {
            return this.aggregator.get(buf, position);
        }

        @Override
        public void close() {
            this.aggregator.close();
        }

        @Override
        public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
            this.aggregator.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
        }

        @Override
        public AggregatorFactory getFactory() {
            return this.factory;
        }

        @Override
        public BufferAggregator asBufferAggregator() {
            return this.aggregator;
        }

        @Override
        public VectorAggregator asVectorAggregator() {
            throw new ISE("Not a VectorAggregator!", new Object[0]);
        }
    }

    private static class VectorAggregatorAdapter
    implements Adapter {
        private final AggregatorFactory factory;
        private final VectorAggregator aggregator;

        VectorAggregatorAdapter(AggregatorFactory factory, VectorAggregator aggregator) {
            this.factory = factory;
            this.aggregator = aggregator;
        }

        @Override
        public void init(ByteBuffer buf, int position) {
            this.aggregator.init(buf, position);
        }

        @Override
        public Object get(ByteBuffer buf, int position) {
            return this.aggregator.get(buf, position);
        }

        @Override
        public void close() {
            this.aggregator.close();
        }

        @Override
        public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
            this.aggregator.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
        }

        @Override
        public AggregatorFactory getFactory() {
            return this.factory;
        }

        @Override
        public BufferAggregator asBufferAggregator() {
            throw new ISE("Not a BufferAggregator!", new Object[0]);
        }

        @Override
        public VectorAggregator asVectorAggregator() {
            return this.aggregator;
        }
    }

    private static interface Adapter
    extends Closeable {
        public void init(ByteBuffer var1, int var2);

        @Nullable
        public Object get(ByteBuffer var1, int var2);

        public void relocate(int var1, int var2, ByteBuffer var3, ByteBuffer var4);

        @Override
        public void close();

        public AggregatorFactory getFactory();

        public BufferAggregator asBufferAggregator();

        public VectorAggregator asVectorAggregator();
    }
}

