/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.java.util.common.logger.Logger;

public class PropertiesModule
implements Module {
    private static final Logger log = new Logger(PropertiesModule.class);
    private final List<String> propertiesFiles;

    public PropertiesModule(List<String> propertiesFiles) {
        this.propertiesFiles = propertiesFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Binder binder) {
        Properties fileProps = new Properties();
        Properties systemProps = System.getProperties();
        Properties props = new Properties(fileProps);
        props.putAll((Map<?, ?>)systemProps);
        for (String propertiesFile : this.propertiesFiles) {
            InputStream stream = ClassLoader.getSystemResourceAsStream(propertiesFile);
            try {
                File workingDirectoryFile;
                if (stream == null && (workingDirectoryFile = new File(systemProps.getProperty("druid.properties.file", propertiesFile))).exists()) {
                    stream = new BufferedInputStream(new FileInputStream(workingDirectoryFile));
                }
                if (stream == null) continue;
                log.debug("Loading properties from %s", new Object[]{propertiesFile});
                try {
                    InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        fileProps.load(in);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (FileNotFoundException e) {
                log.wtf((Throwable)e, "This can only happen if the .exists() call lied.", new Object[0]);
            }
            finally {
                CloseQuietly.close((Closeable)stream);
            }
        }
        binder.bind(Properties.class).toInstance((Object)props);
    }
}

