/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.AbstractPartition;
import org.apache.directory.server.core.partition.impl.btree.ServerEntryCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BTreePartition<ID>
extends AbstractPartition {
    protected static final Set<String> SYS_INDEX_OIDS;
    protected SearchEngine<ServerEntry, ID> searchEngine;
    protected Optimizer optimizer;
    protected SchemaManager schemaManager;
    protected String id;
    protected int cacheSize = -1;
    protected DN suffix;
    private File partitionDir;
    protected ServerEntry contextEntry;
    private Set<Index<? extends Object, ServerEntry, ID>> indexedAttributes = new HashSet<Index<? extends Object, ServerEntry, ID>>();

    protected BTreePartition() {
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public File getPartitionDir() {
        return this.partitionDir;
    }

    public void setPartitionDir(File partitionDir) {
        this.partitionDir = partitionDir;
    }

    public void setIndexedAttributes(Set<Index<? extends Object, ServerEntry, ID>> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public void addIndexedAttributes(Index<? extends Object, ServerEntry, ID> ... indexes) {
        for (Index<? extends Object, ServerEntry, ID> index : indexes) {
            this.indexedAttributes.add(index);
        }
    }

    public Set<Index<? extends Object, ServerEntry, ID>> getIndexedAttributes() {
        return this.indexedAttributes;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SearchEngine<ServerEntry, ID> getSearchEngine() {
        return this.searchEngine;
    }

    public void delete(DeleteOperationContext opContext) throws Exception {
        DN dn = opContext.getDn();
        ID id = this.getEntryId(dn.getNormName());
        if (id == null) {
            throw new LdapNoSuchObjectException(I18n.err((String)I18n.ERR_699, (Object[])new Object[]{dn}));
        }
        if (this.getChildCount(id) > 0) {
            LdapContextNotEmptyException cnee = new LdapContextNotEmptyException(I18n.err((String)I18n.ERR_700, (Object[])new Object[]{dn}));
            throw cnee;
        }
        this.delete(id);
    }

    public abstract void add(AddOperationContext var1) throws Exception;

    public abstract void modify(ModifyOperationContext var1) throws Exception;

    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        return new BaseEntryFilteringCursor(new ServerEntryCursorAdaptor<ID>(this, this.list(this.getEntryId(opContext.getDn().getNormName()))), (SearchingOperationContext)opContext);
    }

    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        SearchControls searchCtls = opContext.getSearchControls();
        IndexCursor<ID, ServerEntry, ID> underlying = this.searchEngine.cursor(opContext.getDn(), opContext.getAliasDerefMode(), opContext.getFilter(), searchCtls);
        return new BaseEntryFilteringCursor(new ServerEntryCursorAdaptor<ID>(this, underlying), (SearchingOperationContext)opContext);
    }

    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        ID id = this.getEntryId(opContext.getDn().getNormName());
        if (id == null) {
            return null;
        }
        ClonedServerEntry entry = this.lookup(id);
        if (opContext.getAttrsId() == null || opContext.getAttrsId().size() == 0) {
            return entry;
        }
        for (AttributeType attributeType : entry.getOriginalEntry().getAttributeTypes()) {
            if (opContext.getAttrsId().contains(attributeType.getOid())) continue;
            entry.removeAttributes(new AttributeType[]{attributeType});
        }
        return entry;
    }

    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        return null != this.getEntryId(opContext.getDn().getNormName());
    }

    public abstract void rename(RenameOperationContext var1) throws Exception;

    public abstract void move(MoveOperationContext var1) throws Exception;

    public abstract void moveAndRename(MoveAndRenameOperationContext var1) throws Exception;

    public abstract void sync() throws Exception;

    public abstract void addIndexOn(Index<? extends Object, ServerEntry, ID> var1) throws Exception;

    public abstract boolean hasUserIndexOn(String var1) throws Exception;

    public abstract boolean hasSystemIndexOn(String var1) throws Exception;

    public abstract Index<String, ServerEntry, ID> getPresenceIndex();

    public abstract Index<ID, ServerEntry, ID> getOneLevelIndex();

    public abstract Index<ID, ServerEntry, ID> getSubLevelIndex();

    public abstract Index<String, ServerEntry, ID> getUpdnIndex();

    public abstract Index<String, ServerEntry, ID> getNdnIndex();

    public abstract Index<ID, ServerEntry, ID> getOneAliasIndex();

    public abstract Index<ID, ServerEntry, ID> getSubAliasIndex();

    public abstract Index<String, ServerEntry, ID> getAliasIndex();

    public abstract void setAliasIndexOn(Index<String, ServerEntry, ID> var1) throws Exception;

    public abstract void setPresenceIndexOn(Index<String, ServerEntry, ID> var1) throws Exception;

    public abstract void setOneLevelIndexOn(Index<ID, ServerEntry, ID> var1) throws Exception;

    public abstract void setUpdnIndexOn(Index<String, ServerEntry, ID> var1) throws Exception;

    public abstract void setNdnIndexOn(Index<String, ServerEntry, ID> var1) throws Exception;

    public abstract void setOneAliasIndexOn(Index<ID, ServerEntry, ID> var1) throws Exception;

    public abstract void setSubAliasIndexOn(Index<ID, ServerEntry, ID> var1) throws Exception;

    public void setSuffix(String suffix) throws LdapInvalidDnException {
        this.suffix = new DN(suffix);
    }

    public String getSuffix() {
        return this.suffix.getName();
    }

    public DN getSuffixDn() {
        return this.suffix;
    }

    public abstract Index<? extends Object, ServerEntry, ID> getUserIndex(String var1) throws Exception;

    public abstract Index<? extends Object, ServerEntry, ID> getSystemIndex(String var1) throws Exception;

    public abstract ID getEntryId(String var1) throws Exception;

    public abstract String getEntryDn(ID var1) throws Exception;

    public abstract ID getParentId(String var1) throws Exception;

    public abstract ID getParentId(ID var1) throws Exception;

    public abstract String getEntryUpdn(ID var1) throws Exception;

    public abstract String getEntryUpdn(String var1) throws Exception;

    public abstract ClonedServerEntry lookup(ID var1) throws Exception;

    public abstract void delete(ID var1) throws Exception;

    public abstract IndexCursor<ID, ServerEntry, ID> list(ID var1) throws Exception;

    public abstract int getChildCount(ID var1) throws Exception;

    public abstract void setProperty(String var1, String var2) throws Exception;

    public abstract String getProperty(String var1) throws Exception;

    public abstract Iterator<String> getUserIndices();

    public abstract Iterator<String> getSystemIndices();

    public abstract int count() throws Exception;

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("1.3.6.1.4.1.18060.0.4.1.2.7");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.3");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.4");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.1");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.5");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.6");
        set.add("1.3.6.1.4.1.18060.0.4.1.2.2");
        SYS_INDEX_OIDS = Collections.unmodifiableSet(set);
    }
}

