/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.KerberosUtils;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.InvalidTicketException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ticket
extends AbstractAsn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(Ticket.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    public static final int TICKET_VNO = 5;
    private int tktvno;
    private byte[] realmBytes;
    private PrincipalName sName;
    private String realm;
    private EncryptedData encPart;
    private EncTicketPart encTicketPart;
    private transient int tktvnoLength;
    private transient int realmLength;
    private transient int sNameLength;
    private transient int encPartLength;
    private transient int ticketSeqLength;
    private transient int ticketLength;

    public Ticket(KerberosPrincipal serverPrincipal, EncryptedData encPart) throws InvalidTicketException {
        this(5, serverPrincipal, encPart);
        this.setServerPrincipal(serverPrincipal);
    }

    public Ticket() {
    }

    public Ticket(int tktvno, KerberosPrincipal serverPrincipal, EncryptedData encPart) throws InvalidTicketException {
        this.tktvno = tktvno;
        this.encPart = encPart;
        this.setServerPrincipal(serverPrincipal);
    }

    public void setEncTicketPart(EncTicketPart decryptedPart) {
        this.encTicketPart = decryptedPart;
    }

    public int getTktVno() {
        return this.tktvno;
    }

    public void setTktVno(int tktvno) {
        this.tktvno = tktvno;
    }

    public PrincipalName getSName() {
        return this.sName;
    }

    public KerberosPrincipal getServerPrincipal() {
        return KerberosUtils.getKerberosPrincipal(this.sName, this.realm);
    }

    public void setSName(PrincipalName sName) {
        this.sName = sName;
    }

    public void setServerPrincipal(KerberosPrincipal serverPrincipal) throws InvalidTicketException {
        try {
            this.sName = new PrincipalName(serverPrincipal.getName(), serverPrincipal.getNameType());
            this.realm = serverPrincipal.getRealm();
        }
        catch (ParseException pe) {
            LOG.error(I18n.err((String)I18n.ERR_135, (Object[])new Object[]{serverPrincipal, pe.getLocalizedMessage()}));
            throw new InvalidTicketException(ErrorType.KRB_ERR_GENERIC, I18n.err((String)I18n.ERR_136, (Object[])new Object[]{pe.getLocalizedMessage()}));
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public EncryptedData getEncPart() {
        return this.encPart;
    }

    public void setEncPart(EncryptedData encPart) {
        this.encPart = encPart;
    }

    public EncTicketPart getEncTicketPart() {
        return this.encTicketPart;
    }

    public int computeLength() {
        this.tktvnoLength = 1 + TLV.getNbBytes((int)this.tktvno) + Value.getNbBytes((int)this.tktvno);
        this.realmBytes = StringTools.getBytesUtf8((String)this.realm);
        this.realmLength = 1 + TLV.getNbBytes((int)this.realmBytes.length) + this.realmBytes.length;
        this.sNameLength = this.sName.computeLength();
        this.encPartLength = this.encPart.computeLength();
        this.ticketSeqLength = 1 + TLV.getNbBytes((int)this.tktvnoLength) + this.tktvnoLength + 1 + TLV.getNbBytes((int)this.realmLength) + this.realmLength + 1 + TLV.getNbBytes((int)this.sNameLength) + this.sNameLength + 1 + TLV.getNbBytes((int)this.encPartLength) + this.encPartLength;
        this.ticketLength = 1 + TLV.getNbBytes((int)this.ticketSeqLength) + this.ticketSeqLength;
        return 1 + TLV.getNbBytes((int)this.ticketLength) + this.ticketLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer buffer = ByteBuffer.allocate(this.computeLength());
        try {
            buffer.put((byte)97);
            buffer.put(TLV.getBytes((int)this.ticketLength));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.ticketSeqLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.tktvnoLength));
            Value.encode((ByteBuffer)buffer, (int)this.tktvno);
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.realmLength));
            buffer.put((byte)27);
            buffer.put(TLV.getBytes((int)this.realmBytes.length));
            buffer.put(this.realmBytes);
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes((int)this.sNameLength));
            this.sName.encode(buffer);
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes((int)this.encPartLength));
            this.encPart.encode(buffer);
        }
        catch (BufferOverflowException boe) {
            LOG.error(I18n.err((String)I18n.ERR_137, (Object[])new Object[]{1 + TLV.getNbBytes((int)this.ticketLength) + this.ticketLength, buffer.capacity()}));
            throw new EncoderException(I18n.err((String)I18n.ERR_138, (Object[])new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug("Ticket encoding : {}", (Object)StringTools.dumpBytes((byte[])buffer.array()));
            LOG.debug("Ticket initial value : {}", (Object)((Object)((Object)this)).toString());
        }
        return buffer;
    }
}

