/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.types.HostAddrType;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class HostAddressDecoder {
    protected static HostAddress decode(DERSequence sequence) {
        HostAddrType type = HostAddrType.ADDRTYPE_INET;
        byte[] value = null;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger addressType = (DERInteger)derObject;
                    type = HostAddrType.getTypeByOrdinal(addressType.intValue());
                    break;
                }
                case 1: {
                    DEROctetString address = (DEROctetString)derObject;
                    value = address.getOctets();
                }
            }
        }
        return new HostAddress(type, value);
    }

    protected static HostAddresses decodeSequence(DERSequence sequence) {
        HostAddress[] addresses = new HostAddress[sequence.size()];
        int ii = 0;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            HostAddress address;
            DERSequence object = (DERSequence)e.nextElement();
            addresses[ii] = address = HostAddressDecoder.decode(object);
            ++ii;
        }
        return new HostAddresses(addresses);
    }
}

