/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.wire.BlockLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@NotThreadSafe
public final class BlockInfo
implements Serializable {
    private static final long serialVersionUID = 5646834366222004646L;
    private long mBlockId;
    private long mLength;
    private ArrayList<BlockLocation> mLocations = new ArrayList();

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public List<BlockLocation> getLocations() {
        return this.mLocations;
    }

    public BlockInfo setBlockId(long blockId) {
        this.mBlockId = blockId;
        return this;
    }

    public BlockInfo setLength(long length) {
        this.mLength = length;
        return this;
    }

    public BlockInfo setLocations(List<BlockLocation> locations) {
        this.mLocations = new ArrayList(Preconditions.checkNotNull(locations, "locations"));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockInfo)) {
            return false;
        }
        BlockInfo that = (BlockInfo)o;
        return this.mBlockId == that.mBlockId && this.mLength == that.mLength && this.mLocations.equals(that.mLocations);
    }

    public int hashCode() {
        return Objects.hashCode(this.mBlockId, this.mLength, this.mLocations);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.mBlockId).add("length", this.mLength).add("locations", this.mLocations).toString();
    }
}

