/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication.plain;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class PlainSaslClientCallbackHandler
implements CallbackHandler {
    private final String mUserName;
    private final String mPassword;

    public PlainSaslClientCallbackHandler(String userName, String password) {
        this.mUserName = userName;
        this.mPassword = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.mUserName);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passCallback = (PasswordCallback)callback;
                passCallback.setPassword(this.mPassword == null ? null : this.mPassword.toCharArray());
                continue;
            }
            Class<?> callbackClass = callback == null ? null : callback.getClass();
            throw new UnsupportedCallbackException(callback, callbackClass + " is unsupported.");
        }
    }
}

