/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.RetryPolicy;
import alluxio.time.Sleeper;
import alluxio.time.TimeContext;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public abstract class TimeBoundedRetry
implements RetryPolicy {
    private final Clock mClock;
    private final Sleeper mSleeper;
    private final Duration mMaxDuration;
    private final Instant mStartTime;
    private final Instant mEndTime;
    private int mAttemptCount = 0;

    public TimeBoundedRetry(TimeContext timeCtx, Duration maxDuration) {
        this.mClock = timeCtx.getClock();
        this.mSleeper = timeCtx.getSleeper();
        this.mMaxDuration = maxDuration;
        this.mStartTime = this.mClock.instant();
        this.mEndTime = this.mStartTime.plus(this.mMaxDuration);
    }

    @Override
    public int getAttemptCount() {
        return this.mAttemptCount;
    }

    @Override
    public boolean attempt() {
        if (this.mAttemptCount == 0) {
            ++this.mAttemptCount;
            return true;
        }
        Instant now = this.mClock.instant();
        if (now.isAfter(this.mEndTime) || now.equals(this.mEndTime)) {
            return false;
        }
        Duration nextWaitTime = this.computeNextWaitTime();
        if (now.plus(nextWaitTime).isAfter(this.mEndTime)) {
            nextWaitTime = Duration.between(now, this.mEndTime);
        }
        if (nextWaitTime.getNano() > 0) {
            try {
                this.mSleeper.sleep(nextWaitTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        ++this.mAttemptCount;
        return true;
    }

    protected abstract Duration computeNextWaitTime();
}

