/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.conf.AlluxioConfiguration;
import alluxio.heartbeat.HeartbeatContext;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatTimer;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.SecurityUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class HeartbeatThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatThread.class);
    private final String mThreadName;
    private final HeartbeatExecutor mExecutor;
    private final UserState mUserState;
    private HeartbeatTimer mTimer;
    private AlluxioConfiguration mConfiguration;

    @VisibleForTesting
    public static String generateThreadName(String executorName, String threadId) {
        if (threadId == null || threadId.isEmpty()) {
            return executorName;
        }
        return executorName + "-" + threadId;
    }

    public HeartbeatThread(String executorName, String threadId, HeartbeatExecutor executor, long intervalMs, AlluxioConfiguration conf, UserState userState) {
        this.mThreadName = HeartbeatThread.generateThreadName(executorName, threadId);
        this.mExecutor = Preconditions.checkNotNull(executor, "executor");
        Class<? extends HeartbeatTimer> timerClass = HeartbeatContext.getTimerClass(executorName);
        this.mTimer = CommonUtils.createNewClassInstance(timerClass, new Class[]{String.class, Long.TYPE}, new Object[]{this.mThreadName, intervalMs});
        this.mConfiguration = conf;
        this.mUserState = userState;
    }

    public HeartbeatThread(String executorName, HeartbeatExecutor executor, long intervalMs, AlluxioConfiguration conf, UserState userState) {
        this(executorName, null, executor, intervalMs, conf, userState);
    }

    @Override
    public void run() {
        try {
            if (SecurityUtils.isSecurityEnabled(this.mConfiguration) && AuthenticatedClientUser.get(this.mConfiguration) == null) {
                AuthenticatedClientUser.set(this.mUserState.getUser().getName());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to set AuthenticatedClientUser in HeartbeatThread.");
        }
        Thread.currentThread().setName(this.mThreadName);
        try {
            while (!Thread.interrupted()) {
                this.mTimer.tick();
                this.mExecutor.heartbeat();
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in heartbeat executor, Heartbeat Thread shutting down", (Throwable)e);
        }
        finally {
            this.mExecutor.close();
        }
    }

    public void updateIntervalMs(long intervalMs) {
        this.mTimer.setIntervalMs(intervalMs);
    }
}

